/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.api.payments;

import com.paypal.api.payments.EventTypeList;
import com.paypal.base.rest.APIContext;
import com.paypal.base.rest.HttpMethod;
import com.paypal.base.rest.PayPalRESTException;
import com.paypal.base.rest.PayPalResource;
import com.paypal.base.rest.RESTUtil;

public class EventType
extends PayPalResource {
    private String name;
    private String description;

    public EventType() {
    }

    public EventType(String name) {
        this.name = name;
    }

    public static EventTypeList subscribedEventTypes(String accessToken, String webhookId) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return EventType.subscribedEventTypes(apiContext, webhookId);
    }

    public static EventTypeList subscribedEventTypes(APIContext apiContext, String webhookId) throws PayPalRESTException {
        String payLoad;
        if (webhookId == null) {
            throw new IllegalArgumentException("webhookId cannot be null");
        }
        String pattern = "v1/notifications/webhooks/{0}/event-types";
        Object[] parameters = new Object[]{webhookId};
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        EventTypeList eventTypeList = EventType.configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad = "", EventTypeList.class);
        if (eventTypeList == null) {
            eventTypeList = new EventTypeList();
        }
        return eventTypeList;
    }

    public static EventTypeList availableEventTypes(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return EventType.availableEventTypes(apiContext);
    }

    public static EventTypeList availableEventTypes(APIContext apiContext) throws PayPalRESTException {
        String resourcePath = "v1/notifications/webhooks-event-types";
        String payLoad = "";
        EventTypeList eventTypeList = EventType.configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, EventTypeList.class);
        return eventTypeList;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public EventType setName(String name) {
        this.name = name;
        return this;
    }

    public EventType setDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventType)) {
            return false;
        }
        EventType other = (EventType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof EventType;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

