/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.base;

import com.paypal.base.ConfigManager;
import com.paypal.base.rest.PayPalRESTException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public final class SDKUtil {
    private SDKUtil() {
    }

    public static Map<String, String> constructMap(Properties properties) {
        Properties combinedProperties = ConfigManager.combineDefaultProperties(properties);
        HashMap<String, String> propsMap = new HashMap<String, String>();
        Enumeration<?> keys = combinedProperties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString().trim();
            String value = combinedProperties.getProperty(key).trim();
            propsMap.put(key, value);
        }
        return propsMap;
    }

    public static Map<String, String> combineDefaultMap(Map<String, String> receivedMap) {
        return SDKUtil.combineMap(receivedMap, ConfigManager.getDefaultSDKMap());
    }

    public static Map<String, String> combineMap(Map<String, String> highMap, Map<String, String> lowMap) {
        lowMap = lowMap != null ? lowMap : new HashMap<String, String>();
        highMap = highMap != null ? highMap : new HashMap();
        lowMap.putAll(highMap);
        return lowMap;
    }

    public static String validateAndGet(Map<String, String> map, String key) throws PayPalRESTException {
        if (map == null || key == null) {
            throw new PayPalRESTException("Map or Key cannot be null");
        }
        String value = map.get(key);
        if (value == null || value.equals("")) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (!entry.getKey().equalsIgnoreCase(key)) continue;
                value = entry.getValue();
                break;
            }
            if (value == null || value.equals("")) {
                throw new PayPalRESTException(key + " cannot be null");
            }
        }
        return value;
    }
}

