/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.spotify.docker.client.messages.IpamConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class Ipam {
    @JsonProperty(value="Driver")
    private String driver;
    @JsonProperty(value="Config")
    private List<IpamConfig> config;

    private Ipam(Builder builder) {
        this.driver = builder.driver;
        this.config = builder.configs;
    }

    public Ipam() {
    }

    public String driver() {
        return this.driver;
    }

    public List<IpamConfig> config() {
        return this.config;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ipam that = (Ipam)o;
        return Objects.equals(this.driver, that.driver) && Objects.equals(this.config, that.config);
    }

    public int hashCode() {
        return Objects.hash(this.driver, this.config);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("driver", (Object)this.driver).add("config", this.config).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String driver;
        private List<IpamConfig> configs = new ArrayList<IpamConfig>();

        public Builder driver(String driver) {
            this.driver = driver;
            return this;
        }

        public Builder config(String subnet, String ipRange, String gateway) {
            IpamConfig config = new IpamConfig();
            config.subnet(subnet);
            config.ipRange(ipRange);
            config.gateway(gateway);
            this.configs.add(config);
            return this;
        }

        public Ipam build() {
            return new Ipam(this);
        }
    }
}

