/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.shaded.org.glassfish.jersey.jackson;

import com.spotify.docker.client.shaded.com.fasterxml.jackson.jaxrs.base.JsonMappingExceptionMapper;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.jaxrs.base.JsonParseExceptionMapper;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import com.spotify.docker.client.shaded.javax.ws.rs.core.Configuration;
import com.spotify.docker.client.shaded.javax.ws.rs.core.Feature;
import com.spotify.docker.client.shaded.javax.ws.rs.core.FeatureContext;
import com.spotify.docker.client.shaded.javax.ws.rs.ext.MessageBodyReader;
import com.spotify.docker.client.shaded.javax.ws.rs.ext.MessageBodyWriter;
import com.spotify.docker.client.shaded.org.glassfish.jersey.CommonProperties;
import com.spotify.docker.client.shaded.org.glassfish.jersey.internal.util.PropertiesHelper;
import com.spotify.docker.client.shaded.org.glassfish.jersey.jackson.internal.FilteringJacksonJaxbJsonProvider;
import com.spotify.docker.client.shaded.org.glassfish.jersey.jackson.internal.JacksonFilteringFeature;
import com.spotify.docker.client.shaded.org.glassfish.jersey.message.filtering.EntityFilteringFeature;

public class JacksonFeature
implements Feature {
    private static final String JSON_FEATURE = JacksonFeature.class.getSimpleName();

    @Override
    public boolean configure(FeatureContext context) {
        Configuration config = context.getConfiguration();
        String jsonFeature = CommonProperties.getValue(config.getProperties(), config.getRuntimeType(), "jersey.config.jsonFeature", JSON_FEATURE, String.class);
        if (!JSON_FEATURE.equalsIgnoreCase(jsonFeature)) {
            return false;
        }
        context.property(PropertiesHelper.getPropertyNameForRuntime("jersey.config.jsonFeature", config.getRuntimeType()), JSON_FEATURE);
        if (!config.isRegistered(JacksonJaxbJsonProvider.class)) {
            context.register(JsonParseExceptionMapper.class);
            context.register(JsonMappingExceptionMapper.class);
            if (EntityFilteringFeature.enabled(config)) {
                context.register(JacksonFilteringFeature.class);
                context.register(FilteringJacksonJaxbJsonProvider.class, MessageBodyReader.class, MessageBodyWriter.class);
            } else {
                context.register(JacksonJaxbJsonProvider.class, MessageBodyReader.class, MessageBodyWriter.class);
            }
        }
        return true;
    }
}

