/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.bdio.graph;

import com.synopsys.integration.bdio.graph.DependencyGraph;
import com.synopsys.integration.bdio.graph.MutableDependencyGraph;
import com.synopsys.integration.bdio.model.dependency.Dependency;
import java.util.HashSet;
import java.util.Set;

public class DependencyGraphCombiner {
    public void addGraphAsChildrenToRoot(MutableDependencyGraph destinationGraph, DependencyGraph sourceGraph) {
        HashSet<Dependency> encountered = new HashSet<Dependency>();
        for (Dependency dependency : sourceGraph.getRootDependencies()) {
            destinationGraph.addChildToRoot(dependency);
            this.copyDependencyFromGraph(destinationGraph, dependency, sourceGraph, encountered);
        }
    }

    public void addGraphAsChildrenToParent(MutableDependencyGraph destinationGraph, Dependency parent, DependencyGraph sourceGraph) {
        HashSet<Dependency> encountered = new HashSet<Dependency>();
        for (Dependency dependency : sourceGraph.getRootDependencies()) {
            destinationGraph.addChildWithParent(dependency, parent);
            this.copyDependencyFromGraph(destinationGraph, dependency, sourceGraph, encountered);
        }
    }

    public void copyDependencyFromGraph(MutableDependencyGraph destinationGraph, Dependency parentDependency, DependencyGraph sourceGraph, Set<Dependency> encountered) {
        for (Dependency dependency : sourceGraph.getChildrenForParent(parentDependency)) {
            if (!encountered.contains((Object)dependency)) {
                encountered.add(dependency);
                this.copyDependencyFromGraph(destinationGraph, dependency, sourceGraph, encountered);
            }
            destinationGraph.addChildWithParent(dependency, parentDependency);
        }
    }
}

