/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.rest.client;

import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.rest.client.ConnectionResult;
import com.synopsys.integration.rest.client.IntHttpClient;
import com.synopsys.integration.rest.proxy.ProxyInfo;
import com.synopsys.integration.rest.response.Response;
import java.io.IOException;
import java.util.Map;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public abstract class AuthenticatingIntHttpClient
extends IntHttpClient {
    public AuthenticatingIntHttpClient(IntLogger logger, int timeoutInSeconds, boolean alwaysTrustServerCertificate, ProxyInfo proxyInfo) {
        super(logger, timeoutInSeconds, alwaysTrustServerCertificate, proxyInfo);
    }

    public AuthenticatingIntHttpClient(IntLogger logger, int timeoutInSeconds, boolean alwaysTrustServerCertificate, ProxyInfo proxyInfo, CredentialsProvider credentialsProvider, HttpClientBuilder clientBuilder, RequestConfig.Builder defaultRequestConfigBuilder, Map<String, String> commonRequestHeaders) {
        super(logger, timeoutInSeconds, alwaysTrustServerCertificate, proxyInfo, credentialsProvider, clientBuilder, defaultRequestConfigBuilder, commonRequestHeaders);
    }

    public abstract boolean isAlreadyAuthenticated(HttpUriRequest var1);

    public abstract Response attemptAuthentication() throws IntegrationException;

    public final void authenticateRequest(HttpUriRequest request) throws IntegrationException {
        try (Response response = this.attemptAuthentication();){
            this.completeAuthenticationRequest(request, response);
        }
        catch (IOException e) {
            throw new IntegrationException("The request could not be authenticated with the provided credentials: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Response execute(HttpUriRequest request) throws IntegrationException {
        return this.execute(request, (HttpContext)new BasicHttpContext());
    }

    @Override
    public Response execute(HttpUriRequest request, HttpContext httpContext) throws IntegrationException {
        return this.retryExecute(request, httpContext, 0);
    }

    public final boolean isUnauthorizedOrForbidden(Response response) {
        Integer statusCode = response.getStatusCode();
        return null == statusCode || statusCode == 401 || statusCode == 403;
    }

    public boolean canConnect() {
        ConnectionResult connectionResult = this.attemptConnection();
        return connectionResult.isSuccess();
    }

    public ConnectionResult attemptConnection() {
        String errorMessage = null;
        Exception exception = null;
        int httpStatusCode = 0;
        try (Response response = this.attemptAuthentication();){
            httpStatusCode = response.getStatusCode();
            if (response.isStatusCodeError()) {
                errorMessage = response.getContentString();
            }
        }
        catch (Exception e) {
            errorMessage = e.getMessage();
            exception = e;
        }
        if (null != errorMessage) {
            this.logger.error(errorMessage);
            return ConnectionResult.FAILURE(httpStatusCode, errorMessage, exception);
        }
        this.logger.info("A successful connection was made.");
        return ConnectionResult.SUCCESS(httpStatusCode);
    }

    protected abstract void completeAuthenticationRequest(HttpUriRequest var1, Response var2) throws IntegrationException;

    private Response retryExecute(HttpUriRequest request, HttpContext httpContext, int retryCount) throws IntegrationException {
        Response response;
        boolean notOkay;
        if (!this.isAlreadyAuthenticated(request)) {
            this.authenticateRequest(request);
        }
        if ((notOkay = this.isUnauthorizedOrForbidden(response = super.execute(request, httpContext))) && retryCount < 2) {
            this.authenticateRequest(request);
            return this.retryExecute(request, httpContext, retryCount + 1);
        }
        if (notOkay) {
            response.throwExceptionForError();
        }
        return response;
    }
}

