/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.java.junit.dataprovider.internal;

import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.internal.convert.ObjectArrayConverter;
import com.tngtech.java.junit.dataprovider.internal.convert.StringConverter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataConverter {
    final ObjectArrayConverter objectArrayConverter = new ObjectArrayConverter();
    final StringConverter stringConverter = new StringConverter();

    public boolean canConvert(Type type) {
        ParameterizedType parameterizedType;
        if (type instanceof Class) {
            return Object[][].class.equals((Object)type) || String[].class.equals((Object)type);
        }
        if (type instanceof ParameterizedType && List.class.isAssignableFrom((Class)(parameterizedType = (ParameterizedType)type).getRawType()) && parameterizedType.getActualTypeArguments().length == 1 && parameterizedType.getActualTypeArguments()[0] instanceof ParameterizedType) {
            ParameterizedType innerType = (ParameterizedType)parameterizedType.getActualTypeArguments()[0];
            return List.class.isAssignableFrom((Class)innerType.getRawType());
        }
        return false;
    }

    public List<Object[]> convert(Object data, boolean isVarArgs, Class<?>[] parameterTypes, DataProvider dataProvider) {
        if (parameterTypes == null) {
            throw new NullPointerException("parameterTypes must not be null");
        }
        if (dataProvider == null) {
            throw new NullPointerException("dataProvider must not be null");
        }
        if (parameterTypes.length == 0) {
            throw new IllegalArgumentException("parameterTypes must not be empty");
        }
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        if (data instanceof Object[][]) {
            for (Object[] arguments : (Object[][])data) {
                result.add(this.objectArrayConverter.convert(arguments, isVarArgs, parameterTypes));
            }
        } else if (data instanceof String[]) {
            int idx = 0;
            for (String argString : (String[])data) {
                result.add(this.stringConverter.convert(argString, isVarArgs, parameterTypes, dataProvider, idx++));
            }
        } else if (data instanceof List) {
            List lists = (List)data;
            for (List arguments : lists) {
                result.add(this.objectArrayConverter.convert(arguments.toArray(), isVarArgs, parameterTypes));
            }
        } else {
            throw new ClassCastException(String.format("Cannot cast to either Object[][], String[], or List<List<Object>> because data was: %s", data));
        }
        return result;
    }
}

