/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.AbstractUpdateImports;
import com.vaadin.flow.server.frontend.NodeUpdater;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskRunNpmInstall;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import org.slf4j.Logger;

public class TaskUpdateImports
extends NodeUpdater {
    TaskUpdateImports(ClassFinder finder, FrontendDependenciesScanner frontendDepScanner, Options options) {
        super(finder, frontendDepScanner, options);
    }

    @Override
    public void execute() {
        UpdateMainImportsFile mainUpdate = new UpdateMainImportsFile(this.finder, this.options, this.frontDeps);
        mainUpdate.run();
    }

    private String getAbsentPackagesMessage() {
        String toolName = TaskRunNpmInstall.getToolName(this.options);
        String lockFile = this.options.isEnableBun() ? "bun.lockb" : (this.options.isEnablePnpm() ? "pnpm-lock.yaml" : "package-lock.json");
        String note = "";
        if (this.options.isEnablePnpm()) {
            note = "\nMake sure first that `pnpm` command is installed, otherwise you should install it using npm: `npm add -g pnpm@8.6.11`";
        }
        return String.format("If the build fails, check that npm packages are installed.\n\n  To fix the build remove `%s` and `node_modules` directory to reset modules.\n  In addition you may run `%s install` to fix `node_modules` tree structure.%s", lockFile, toolName, note);
    }

    private class UpdateMainImportsFile
    extends AbstractUpdateImports {
        UpdateMainImportsFile(ClassFinder classFinder, Options options, FrontendDependenciesScanner scanner) {
            super(options, scanner, classFinder);
        }

        @Override
        protected Logger getLogger() {
            return TaskUpdateImports.this.log();
        }

        @Override
        protected String getImportsNotFoundMessage() {
            return TaskUpdateImports.this.getAbsentPackagesMessage();
        }
    }
}

