/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.AbstractUpdateImports;
import com.vaadin.flow.server.frontend.GeneratedFilesSupport;
import com.vaadin.flow.server.frontend.NodeUpdater;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskRunNpmInstall;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import org.slf4j.Logger;

public class TaskUpdateImports
extends NodeUpdater {
    private GeneratedFilesSupport generatedFilesSupport = new GeneratedFilesSupport();

    TaskUpdateImports(FrontendDependenciesScanner frontendDepScanner, Options options) {
        super(frontendDepScanner, options);
    }

    @Override
    public void setGeneratedFileSupport(GeneratedFilesSupport support) {
        this.generatedFilesSupport = support;
    }

    @Override
    public void execute() {
        UpdateMainImportsFile mainUpdate = new UpdateMainImportsFile(this.options, this.frontDeps, this.generatedFilesSupport);
        mainUpdate.run();
    }

    private String getAbsentPackagesMessage() {
        String toolName = TaskRunNpmInstall.getToolName(this.options);
        String lockFile = this.options.isEnableBun() ? "bun.lockb/bun.lock" : (this.options.isEnablePnpm() ? "pnpm-lock.yaml" : "package-lock.json");
        String note = "";
        if (this.options.isEnablePnpm()) {
            note = "\nMake sure first that `pnpm` command is installed, otherwise you should install it using npm: `npm add -g pnpm@8.6.11`";
        }
        return String.format("If the build fails, check that npm packages are installed.\n\n  To fix the build remove `%s` and `node_modules` directory to reset modules.\n  In addition you may run `%s install` to fix `node_modules` tree structure.%s", lockFile, toolName, note);
    }

    private class UpdateMainImportsFile
    extends AbstractUpdateImports {
        UpdateMainImportsFile(Options options, FrontendDependenciesScanner scanner, GeneratedFilesSupport generatedFilesSupport) {
            super(options, scanner, generatedFilesSupport);
        }

        @Override
        protected Logger getLogger() {
            return TaskUpdateImports.this.log();
        }

        @Override
        protected String getImportsNotFoundMessage() {
            return TaskUpdateImports.this.getAbsentPackagesMessage();
        }
    }
}

