/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.format;

import com.vladsch.flexmark.util.BiFunction;
import com.vladsch.flexmark.util.Utils;
import com.vladsch.flexmark.util.collection.BoundedMaxAggregator;
import com.vladsch.flexmark.util.collection.BoundedMinAggregator;
import com.vladsch.flexmark.util.format.MarkdownTable;
import com.vladsch.flexmark.util.format.TableCaptionRow;
import com.vladsch.flexmark.util.format.TableCell;
import com.vladsch.flexmark.util.format.TableRow;
import com.vladsch.flexmark.util.format.TableRowManipulator;
import com.vladsch.flexmark.util.format.TableSection;
import com.vladsch.flexmark.util.format.TableSectionType;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableCellOffsetInfo {
    public static final int ROW_START = 1;
    public static final int TEXT_START = 2;
    public static final int TEXT_END = 4;
    public static final int ROW_END = 8;
    private static final HashMap<TableSectionType, Integer> DEFAULT_STOP_POINTS_MAP = new HashMap();
    public final MarkdownTable table;
    public final int offset;
    public final TableSection section;
    public final TableRow tableRow;
    public final TableCell tableCell;
    public final int row;
    public final int column;
    public final Integer insideColumn;
    public final Integer insideOffset;

    public TableCellOffsetInfo(int offset, MarkdownTable table, TableSection section, TableRow tableRow, TableCell tableCell, int row, int column, Integer insideColumn, Integer insideOffset) {
        this.offset = offset;
        this.table = table;
        this.section = section;
        this.tableRow = tableRow;
        this.tableCell = tableCell;
        this.row = row;
        this.column = column;
        this.insideColumn = insideColumn;
        this.insideOffset = insideOffset;
    }

    public boolean isCaptionLine() {
        return this.tableRow instanceof TableCaptionRow && this.section == this.table.caption;
    }

    public boolean isSeparatorLine() {
        return this.section.sectionType == TableSectionType.SEPARATOR;
    }

    public boolean isInsideCaption() {
        return this.isCaptionLine() && this.getInsideColumn();
    }

    public boolean isAfterCaption() {
        return this.isCaptionLine() && this.isAfterCells();
    }

    public boolean isBeforeCaption() {
        return this.isCaptionLine() && this.isBeforeCells();
    }

    public boolean isInsideCell() {
        return this.tableRow != null && this.tableCell != null && this.insideColumn != null;
    }

    public boolean getInsideColumn() {
        return this.insideColumn != null;
    }

    public boolean isBeforeCells() {
        return this.tableRow != null && this.tableCell != null && this.insideColumn == null && this.column < this.tableRow.cells.size() && this.offset <= this.tableCell.getStartOffset(this.getPreviousCell());
    }

    public TableCell getPreviousCell() {
        return this.getPreviousCell(1);
    }

    public TableCell getPreviousCell(int offset) {
        return this.getPreviousCell(this.tableRow, offset);
    }

    public TableCell getPreviousCell(TableRow tableRow, int offset) {
        return this.column >= offset && tableRow != null ? tableRow.cells.get(this.column - offset) : null;
    }

    public boolean isInCellSpan() {
        return this.tableRow != null && this.tableCell != null && this.insideColumn == null && this.offset >= this.tableCell.getStartOffset(this.getPreviousCell()) && this.offset < this.tableCell.getEndOffset();
    }

    public boolean isAfterCells() {
        return this.tableRow != null && this.tableCell != null && this.insideColumn == null && this.column == this.tableRow.cells.size() && this.offset >= this.tableCell.getEndOffset();
    }

    public boolean canDeleteColumn() {
        return this.insideColumn != null && this.table.getMinColumnsWithoutColumns(true, this.column) > 0;
    }

    public boolean canDeleteRow() {
        return this.tableRow != null && this.section != this.table.separator && this.table.body.rows.size() + this.table.header.rows.size() > 1;
    }

    public boolean isFirstCell() {
        return this.getInsideColumn() && this.column == 0;
    }

    public boolean isLastCell() {
        return this.getInsideColumn() && this.column + 1 == this.tableRow.cells.size();
    }

    public boolean isLastRow() {
        return this.row + 1 == this.table.getAllRowsCount();
    }

    public TableCellOffsetInfo previousCellOffset(Integer insideOffset) {
        if (this.getInsideColumn() && this.column > 0) {
            TableCell cell = this.getPreviousCell();
            TableCell previousCell = this.getPreviousCell(2);
            if (insideOffset == null) {
                cell.textToInsideOffset(this.tableCell.insideToTextOffset(this.insideOffset == null ? 0 : this.insideOffset, previousCell), previousCell);
            }
            return this.table.getCellOffsetInfo(cell.getTextStartOffset(previousCell) + Utils.maxLimit(cell.getCellSize(previousCell), Utils.minLimit(0, insideOffset)));
        }
        return null;
    }

    public TableCellOffsetInfo nextCellOffset(Integer insideOffset) {
        if (this.getInsideColumn() && this.column + 1 < this.tableRow.cells.size()) {
            TableCell cell = this.getPreviousCell();
            TableCell previousCell = this.getPreviousCell(2);
            if (insideOffset == null) {
                cell.textToInsideOffset(this.tableCell.insideToTextOffset(this.insideOffset == null ? 0 : this.insideOffset, previousCell), previousCell);
            }
            return this.table.getCellOffsetInfo(cell.getTextStartOffset(previousCell) + Utils.maxLimit(cell.getCellSize(previousCell), Utils.minLimit(0, insideOffset)));
        }
        return null;
    }

    public TableCellOffsetInfo previousRowOffset(Integer insideOffset) {
        if (this.row > 0) {
            List<TableRow> allRows = this.table.getAllRows();
            TableRow otherRow = allRows.get(this.row - 1);
            if (this.getInsideColumn() && this.column < otherRow.cells.size()) {
                TableCell cell = this.getPreviousCell();
                TableCell previousCell = this.getPreviousCell(2);
                if (insideOffset == null) {
                    cell.textToInsideOffset(this.tableCell.insideToTextOffset(this.insideOffset == null ? 0 : this.insideOffset, previousCell), previousCell);
                }
                return this.table.getCellOffsetInfo(cell.getTextStartOffset(previousCell) + Utils.maxLimit(cell.getCellSize(previousCell), Utils.minLimit(0, insideOffset)));
            }
            if (this.isBeforeCells()) {
                return this.table.getCellOffsetInfo(otherRow.cells.get(0).getStartOffset(null));
            }
            return this.table.getCellOffsetInfo(otherRow.cells.get(otherRow.cells.size() - 1).getEndOffset());
        }
        return null;
    }

    public TableCellOffsetInfo nextRowOffset(Integer insideOffset) {
        if (this.row + 1 < this.table.getAllRowsCount()) {
            List<TableRow> allRows = this.table.getAllRows();
            TableRow otherRow = allRows.get(this.row + 1);
            if (this.getInsideColumn() && this.column < otherRow.cells.size()) {
                TableCell cell = otherRow.cells.get(this.column);
                TableCell previousCell = this.getPreviousCell(otherRow, 1);
                if (insideOffset == null) {
                    cell.textToInsideOffset(this.tableCell.insideToTextOffset(this.insideOffset == null ? 0 : this.insideOffset, previousCell), previousCell);
                }
                return this.table.getCellOffsetInfo(cell.getTextStartOffset(previousCell) + Utils.maxLimit(cell.getCellSize(previousCell), Utils.minLimit(0, insideOffset)));
            }
            if (this.isBeforeCells()) {
                return this.table.getCellOffsetInfo(otherRow.cells.get(0).getStartOffset(null));
            }
            return this.table.getCellOffsetInfo(otherRow.cells.get(otherRow.cells.size() - 1).getEndOffset());
        }
        return null;
    }

    public TableCellOffsetInfo nextOffsetStop(Map<TableSectionType, Integer> stopPointsMap) {
        int stopOffset = TableCellOffsetInfo.getStopOffset(this.offset, this.table, stopPointsMap, true);
        if (stopOffset != -1) {
            return this.table.getCellOffsetInfo(stopOffset);
        }
        List<TableRow> allRows = this.table.getAllSectionRows();
        TableRow lastRow = allRows.get(allRows.size() - 1);
        TableCell lastCell = lastRow.cells.get(lastRow.cells.size() - 1);
        int offset = lastCell.getEndOffset();
        BasedSequence baseSequence = lastCell.text.getBaseSequence();
        int eolPos = baseSequence.endOfLineAnyEOL(offset);
        return this.table.getCellOffsetInfo(eolPos == -1 ? offset : eolPos + baseSequence.eolLength(eolPos));
    }

    public TableCellOffsetInfo previousOffsetStop(Map<TableSectionType, Integer> stopPointsMap) {
        int stopOffset = TableCellOffsetInfo.getStopOffset(this.offset, this.table, stopPointsMap, false);
        if (stopOffset != -1) {
            return this.table.getCellOffsetInfo(stopOffset);
        }
        return this.table.getCellOffsetInfo(this.table.getTableStartOffset());
    }

    private static boolean haveStopPoint(int flags, int mask) {
        return (flags & mask) != 0;
    }

    private static boolean haveRowStart(int flags) {
        return (flags & 1) != 0;
    }

    private static boolean haveRowEnd(int flags) {
        return (flags & 8) != 0;
    }

    private static boolean haveTextStart(int flags) {
        return (flags & 2) != 0;
    }

    private static boolean haveTextEnd(int flags) {
        return (flags & 4) != 0;
    }

    private static int getStopOffset(int offset, final MarkdownTable table, Map<TableSectionType, Integer> stopPointsMap, boolean nextOffset) {
        final Integer[] result = new Integer[]{null};
        final Map<TableSectionType, Integer> useStopPointsMap = stopPointsMap == null ? DEFAULT_STOP_POINTS_MAP : stopPointsMap;
        final BiFunction<Integer, Integer, Integer> aggregator = nextOffset ? new BoundedMinAggregator(offset) : new BoundedMaxAggregator(offset);
        table.forAllSectionRows(new TableRowManipulator(){

            @Override
            public int apply(TableRow row, int allRowsIndex, ArrayList<TableRow> rows, int index) {
                int flags;
                TableSection section = table.getAllRowsSection(allRowsIndex);
                if (!row.cells.isEmpty() && useStopPointsMap.containsKey((Object)section.sectionType) && (flags = ((Integer)useStopPointsMap.get((Object)section.sectionType)).intValue()) != 0) {
                    int rowStart = row.cells.get(0).getStartOffset(null);
                    int rowEnd = row.cells.get(row.cells.size() - 1).getEndOffset();
                    if (TableCellOffsetInfo.haveRowStart(flags)) {
                        result[0] = (Integer)aggregator.apply(result[0], rowStart);
                    }
                    if (TableCellOffsetInfo.haveStopPoint(flags, 6)) {
                        TableCell previousCell = null;
                        for (TableCell cell : row.cells) {
                            if (TableCellOffsetInfo.haveTextStart(flags)) {
                                int textStart = cell.getTextStartOffset(previousCell);
                                result[0] = (Integer)aggregator.apply(result[0], textStart);
                            }
                            if (TableCellOffsetInfo.haveTextEnd(flags)) {
                                int textEnd = cell.getTextEndOffset(previousCell);
                                result[0] = (Integer)aggregator.apply(result[0], textEnd);
                            }
                            previousCell = cell;
                        }
                    }
                    if (TableCellOffsetInfo.haveRowEnd(flags)) {
                        result[0] = (Integer)aggregator.apply(result[0], rowEnd);
                    }
                }
                return 0;
            }
        });
        return result[0] == null ? -1 : result[0];
    }

    public String toString() {
        return "CellOffsetInfo{ offset=" + this.offset + ", row=" + this.row + ", column=" + this.column + ", insideColumn=" + this.insideColumn + ", insideOffset=" + this.insideOffset + '}';
    }

    static {
        DEFAULT_STOP_POINTS_MAP.put(TableSectionType.HEADER, 4);
        DEFAULT_STOP_POINTS_MAP.put(TableSectionType.SEPARATOR, 6);
        DEFAULT_STOP_POINTS_MAP.put(TableSectionType.BODY, 4);
        DEFAULT_STOP_POINTS_MAP.put(TableSectionType.CAPTION, 4);
    }
}

