/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overcast.support.libvirt.jdom;

import com.xebialabs.overcast.support.libvirt.Disk;
import com.xebialabs.overcast.support.libvirt.JDomUtil;
import com.xebialabs.overcast.support.libvirt.LibvirtRuntimeException;
import com.xebialabs.overcast.support.libvirt.LibvirtUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.libvirt.Connect;
import org.libvirt.LibvirtException;
import org.libvirt.StorageVol;

public final class DiskXml {
    private static final String XPATH_DISK_DEV = "//target/@dev";
    private static final String XPATH_DISK_FILE = "//source/@file";
    private static final String XPATH_DISK_TYPE = "//driver[@name='qemu']/@type";
    private static final String XPATH_DISK = "/domain/devices/disk[@device='disk']";

    private DiskXml() {
    }

    public static void updateDisks(Document domainXml, List<StorageVol> volumes) throws LibvirtException {
        XPathFactory xpf = XPathFactory.instance();
        XPathExpression diskExpr = xpf.compile(XPATH_DISK, Filters.element());
        XPathExpression fileExpr = xpf.compile(XPATH_DISK_FILE, Filters.attribute());
        List disks = diskExpr.evaluate((Object)domainXml);
        Iterator<StorageVol> cloneDiskIter = volumes.iterator();
        for (Element disk : disks) {
            Attribute file = (Attribute)fileExpr.evaluateFirst((Object)disk);
            StorageVol cloneDisk = cloneDiskIter.next();
            file.setValue(cloneDisk.getPath());
        }
    }

    public static List<Disk> getDisks(Connect connect, Document domainXml) {
        try {
            ArrayList<Disk> ret = new ArrayList<Disk>();
            XPathFactory xpf = XPathFactory.instance();
            XPathExpression diskExpr = xpf.compile(XPATH_DISK, Filters.element());
            XPathExpression typeExpr = xpf.compile(XPATH_DISK_TYPE, Filters.attribute());
            XPathExpression fileExpr = xpf.compile(XPATH_DISK_FILE, Filters.attribute());
            XPathExpression devExpr = xpf.compile(XPATH_DISK_DEV, Filters.attribute());
            List disks = diskExpr.evaluate((Object)domainXml);
            for (Element disk : disks) {
                Attribute type = (Attribute)typeExpr.evaluateFirst((Object)disk);
                Attribute file = (Attribute)fileExpr.evaluateFirst((Object)disk);
                Attribute dev = (Attribute)devExpr.evaluateFirst((Object)disk);
                StorageVol volume = LibvirtUtil.findVolume(connect, file.getValue());
                ret.add(new Disk(dev.getValue(), file.getValue(), volume, type.getValue()));
            }
            return ret;
        }
        catch (LibvirtException e) {
            throw new LibvirtRuntimeException(e);
        }
    }

    public static String cloneVolumeXml(Disk backingDisk, String clonedDiskName) throws IOException {
        Element volume = new Element("volume");
        volume.addContent((Content)new Element("name").setText(clonedDiskName));
        volume.addContent((Content)new Element("allocation").setText("0"));
        volume.addContent((Content)new Element("capacity").setText("" + backingDisk.getInfo().capacity));
        Element target = new Element("target");
        volume.addContent((Content)target);
        target.addContent((Content)new Element("format").setAttribute("type", backingDisk.format));
        target.addContent((Content)new Element("compat").setText("1.1"));
        Element backingStore = new Element("backingStore");
        volume.addContent((Content)backingStore);
        backingStore.addContent((Content)new Element("path").setText(backingDisk.file));
        backingStore.addContent((Content)new Element("format").setAttribute("type", backingDisk.format));
        return JDomUtil.elementToString(volume);
    }
}

