/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overcast.support.libvirt.jdom;

import com.xebialabs.overcast.support.libvirt.Filesystem;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;

public final class FilesystemXml {
    private static final String XPATH_FILESYSTEM = "/domain/devices/filesystem[@type='mount']";

    private FilesystemXml() {
    }

    public static Element toFileSystemXml(Filesystem fs) {
        Element filesystem = new Element("filesystem").setAttribute("type", "mount").setAttribute("accessmode", fs.accessMode.name().toLowerCase());
        filesystem.addContent((Content)new Element("source").setAttribute("dir", fs.source));
        filesystem.addContent((Content)new Element("target").setAttribute("dir", fs.target));
        if (fs.readOnly) {
            filesystem.addContent((Content)new Element("readonly"));
        }
        return filesystem;
    }

    public static void removeFilesystemsWithTarget(Document domainXml, String targetDir) {
        XPathFactory xpf = XPathFactory.instance();
        XPathExpression fsExpr = xpf.compile(String.format("/domain/devices/filesystem[@type='mount']/target[@dir='%s']", targetDir), Filters.element());
        List tfs = fsExpr.evaluate((Object)domainXml);
        for (Element e : tfs) {
            e.getParentElement().getParentElement().removeContent((Content)e.getParentElement());
        }
    }

    public static Map<String, Filesystem> getFilesystems(Document domainXml) {
        HashMap<String, Filesystem> ret = new HashMap<String, Filesystem>();
        XPathFactory xpf = XPathFactory.instance();
        XPathExpression fsExpr = xpf.compile(XPATH_FILESYSTEM, Filters.element());
        List filesystems = fsExpr.evaluate((Object)domainXml);
        for (Element fs : filesystems) {
            Attribute accessMode = fs.getAttribute("accessmode");
            String source = fs.getChild("source").getAttribute("dir").getValue();
            String target = fs.getChild("target").getAttribute("dir").getValue();
            boolean readOnly = fs.getChild("readonly") != null;
            ret.put(target, new Filesystem(source, target, Filesystem.AccessMode.valueOf(accessMode.getValue().toUpperCase(Locale.US)), readOnly));
        }
        return ret;
    }
}

