/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overcast.support.libvirt.jdom;

import java.util.HashMap;
import java.util.Map;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InterfaceXml {
    private static final Logger logger = LoggerFactory.getLogger(InterfaceXml.class);

    private InterfaceXml() {
    }

    public static Map<String, String> getMacs(Document domainXml) {
        HashMap<String, String> macs = new HashMap<String, String>();
        XPathFactory xpf = XPathFactory.instance();
        XPathExpression interfaces = xpf.compile("/domain/devices/interface", Filters.element());
        for (Element iface : interfaces.evaluate((Object)domainXml)) {
            Element sourceElement;
            String mac;
            Element macElement;
            String interfaceType = iface.getAttribute("type").getValue();
            logger.debug("Detecting IP on network of type '{}'", (Object)interfaceType);
            if ("bridge".equals(interfaceType)) {
                macElement = iface.getChild("mac");
                mac = macElement.getAttribute("address").getValue();
                sourceElement = iface.getChild("source");
                String bridge = sourceElement.getAttribute("bridge").getValue();
                logger.info("Detected MAC '{}' on bridge '{}'", (Object)mac, (Object)bridge);
                macs.put(bridge, mac);
                continue;
            }
            if ("network".equals(interfaceType)) {
                macElement = iface.getChild("mac");
                mac = macElement.getAttribute("address").getValue();
                sourceElement = iface.getChild("source");
                String network = sourceElement.getAttribute("network").getValue();
                logger.info("Detected MAC '{}' on network '{}'", (Object)mac, (Object)network);
                macs.put(network, mac);
                continue;
            }
            logger.warn("Ignoring network of type {}", (Object)interfaceType);
        }
        return macs;
    }
}

