/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overcast.support.virtualbox;

public enum VirtualboxState {
    POWEROFF,
    ABORTED,
    SAVED,
    RUNNING;


    public static VirtualboxState fromStatusString(String s) {
        String stateString = VirtualboxState.findState(s);
        if (stateString.contains("powered off")) {
            return POWEROFF;
        }
        if (stateString.contains("saved")) {
            return POWEROFF;
        }
        if (stateString.contains("aborted")) {
            return ABORTED;
        }
        if (stateString.contains("running")) {
            return RUNNING;
        }
        throw new IllegalStateException("Can not detect state for state string: " + stateString);
    }

    private static String findState(String s) {
        String[] lines;
        for (String line : lines = s.split("\n")) {
            if (!line.startsWith("State:")) continue;
            return line;
        }
        throw new IllegalArgumentException("Expected 'State:...' but was: '" + s + "'.");
    }
}

