/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.collections.BulkTest;

public abstract class AbstractTestObject
extends BulkTest {
    public static final int COLLECTIONS_MAJOR_VERSION = 3;

    public AbstractTestObject(String testName) {
        super(testName);
    }

    public abstract Object makeObject();

    public boolean supportsEmptyCollections() {
        return true;
    }

    public boolean supportsFullCollections() {
        return true;
    }

    public boolean isTestSerialization() {
        return true;
    }

    public boolean isEqualsCheckable() {
        return true;
    }

    public void testObjectEqualsSelf() {
        Object obj = this.makeObject();
        AbstractTestObject.assertEquals((String)"A Object should equal itself", (Object)obj, (Object)obj);
    }

    public void testEqualsNull() {
        Object obj = this.makeObject();
        AbstractTestObject.assertEquals((boolean)false, (boolean)obj.equals(null));
    }

    public void testObjectHashCodeEqualsSelfHashCode() {
        Object obj = this.makeObject();
        AbstractTestObject.assertEquals((String)"hashCode should be repeatable", (int)obj.hashCode(), (int)obj.hashCode());
    }

    public void testObjectHashCodeEqualsContract() {
        Object obj2;
        Object obj1 = this.makeObject();
        if (obj1.equals(obj1)) {
            AbstractTestObject.assertEquals((String)"[1] When two objects are equal, their hashCodes should be also.", (int)obj1.hashCode(), (int)obj1.hashCode());
        }
        if (obj1.equals(obj2 = this.makeObject())) {
            AbstractTestObject.assertEquals((String)"[2] When two objects are equal, their hashCodes should be also.", (int)obj1.hashCode(), (int)obj2.hashCode());
            AbstractTestObject.assertTrue((String)"When obj1.equals(obj2) is true, then obj2.equals(obj1) should also be true", (boolean)obj2.equals(obj1));
        }
    }

    public void testSerializeDeserializeThenCompare() throws Exception {
        Object obj = this.makeObject();
        if (obj instanceof Serializable && this.isTestSerialization()) {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(obj);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            Object dest = in.readObject();
            in.close();
            if (this.isEqualsCheckable()) {
                AbstractTestObject.assertEquals((String)"obj != deserialize(serialize(obj))", (Object)obj, (Object)dest);
            }
        }
    }

    public void testSimpleSerialization() throws Exception {
        Object o = this.makeObject();
        if (o instanceof Serializable && this.isTestSerialization()) {
            byte[] objekt = this.writeExternalFormToBytes((Serializable)o);
            Object object = this.readExternalFormFromBytes(objekt);
        }
    }

    public void testCanonicalEmptyCollectionExists() {
        Object object;
        if (this.supportsEmptyCollections() && this.isTestSerialization() && !this.skipSerializedCanonicalTests() && (object = this.makeObject()) instanceof Serializable) {
            String name = this.getCanonicalEmptyCollectionName(object);
            AbstractTestObject.assertTrue((String)("Canonical empty collection (" + name + ") is not in CVS"), (boolean)new File(name).exists());
        }
    }

    public void testCanonicalFullCollectionExists() {
        Object object;
        if (this.supportsFullCollections() && this.isTestSerialization() && !this.skipSerializedCanonicalTests() && (object = this.makeObject()) instanceof Serializable) {
            String name = this.getCanonicalFullCollectionName(object);
            AbstractTestObject.assertTrue((String)("Canonical full collection (" + name + ") is not in CVS"), (boolean)new File(name).exists());
        }
    }

    public String getCompatibilityVersion() {
        return "1";
    }

    protected String getCanonicalEmptyCollectionName(Object object) {
        StringBuffer retval = new StringBuffer();
        retval.append("data/test/");
        String colName = object.getClass().getName();
        colName = colName.substring(colName.lastIndexOf(".") + 1, colName.length());
        retval.append(colName);
        retval.append(".emptyCollection.version");
        retval.append(this.getCompatibilityVersion());
        retval.append(".obj");
        return retval.toString();
    }

    protected String getCanonicalFullCollectionName(Object object) {
        StringBuffer retval = new StringBuffer();
        retval.append("data/test/");
        String colName = object.getClass().getName();
        colName = colName.substring(colName.lastIndexOf(".") + 1, colName.length());
        retval.append(colName);
        retval.append(".fullCollection.version");
        retval.append(this.getCompatibilityVersion());
        retval.append(".obj");
        return retval.toString();
    }

    protected void writeExternalFormToDisk(Serializable o, String path) throws IOException {
        FileOutputStream fileStream = new FileOutputStream(path);
        this.writeExternalFormToStream(o, fileStream);
    }

    protected byte[] writeExternalFormToBytes(Serializable o) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        this.writeExternalFormToStream(o, byteStream);
        return byteStream.toByteArray();
    }

    protected Object readExternalFormFromDisk(String path) throws IOException, ClassNotFoundException {
        FileInputStream stream = new FileInputStream(path);
        return this.readExternalFormFromStream(stream);
    }

    protected Object readExternalFormFromBytes(byte[] b) throws IOException, ClassNotFoundException {
        ByteArrayInputStream stream = new ByteArrayInputStream(b);
        return this.readExternalFormFromStream(stream);
    }

    protected boolean skipSerializedCanonicalTests() {
        return Boolean.getBoolean("org.apache.commons.collections:with-clover");
    }

    private Object readExternalFormFromStream(InputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream oStream = new ObjectInputStream(stream);
        return oStream.readObject();
    }

    private void writeExternalFormToStream(Serializable o, OutputStream stream) throws IOException {
        ObjectOutputStream oStream = new ObjectOutputStream(stream);
        oStream.writeObject(o);
    }
}

