/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.packageresolver.linux;

import de.flapdoodle.embed.mongo.packageresolver.PackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.PlatformMatch;
import de.flapdoodle.embed.mongo.packageresolver.linux.UbuntuPackageResolver;
import de.flapdoodle.embed.process.config.store.DistributionPackage;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.distribution.Version;
import de.flapdoodle.os.ImmutablePlatform;
import de.flapdoodle.os.OS;
import de.flapdoodle.os.Platform;
import de.flapdoodle.os.linux.LinuxMintVersion;
import java.util.Optional;

public class LinuxMintPackageResolver
implements PackageFinder {
    private final UbuntuPackageResolver ubuntuPackageResolver;

    public LinuxMintPackageResolver(UbuntuPackageResolver ubuntuPackageResolver) {
        this.ubuntuPackageResolver = ubuntuPackageResolver;
    }

    @Override
    public Optional<DistributionPackage> packageFor(Distribution distribution) {
        if (PlatformMatch.withOs(OS.Linux).withVersion((de.flapdoodle.os.Version[])LinuxMintVersion.values()).match(distribution)) {
            if (!distribution.platform().version().isPresent()) {
                throw new RuntimeException("version not set: " + distribution);
            }
            de.flapdoodle.os.Version currentVersion = (de.flapdoodle.os.Version)distribution.platform().version().get();
            if (currentVersion instanceof LinuxMintVersion) {
                Distribution asUbuntudistribution = Distribution.of((Version)distribution.version(), (Platform)ImmutablePlatform.copyOf((Platform)distribution.platform()).withVersion((de.flapdoodle.os.Version)((LinuxMintVersion)currentVersion).matchingUbuntuVersion()));
                return this.ubuntuPackageResolver.packageFor(asUbuntudistribution);
            }
            throw new IllegalArgumentException("Version is not a " + LinuxMintVersion.class + ": " + currentVersion);
        }
        return Optional.empty();
    }
}

