/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.logbackgelf;

import de.siegmar.logbackgelf.AbstractGelfAppender;
import de.siegmar.logbackgelf.AddressResolver;
import de.siegmar.logbackgelf.TcpConnection;
import de.siegmar.logbackgelf.pool.PooledObjectConsumer;
import de.siegmar.logbackgelf.pool.PooledObjectFactory;
import de.siegmar.logbackgelf.pool.SimpleObjectPool;
import java.io.IOException;
import java.util.Arrays;
import javax.net.SocketFactory;

public class GelfTcpAppender
extends AbstractGelfAppender {
    private static final int DEFAULT_CONNECT_TIMEOUT = 15000;
    private static final int DEFAULT_RECONNECT_INTERVAL = 60;
    private static final int DEFAULT_MAX_RETRIES = 2;
    private static final int DEFAULT_RETRY_DELAY = 3000;
    private static final int DEFAULT_POOL_SIZE = 2;
    private static final int DEFAULT_POOL_MAX_WAIT_TIME = 5000;
    private int connectTimeout = 15000;
    private int reconnectInterval = 60;
    private int maxRetries = 2;
    private int retryDelay = 3000;
    private int poolSize = 2;
    private int poolMaxWaitTime = 5000;
    private SimpleObjectPool<TcpConnection> connectionPool;

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReconnectInterval() {
        return this.reconnectInterval;
    }

    public void setReconnectInterval(int reconnectInterval) {
        this.reconnectInterval = reconnectInterval;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public int getRetryDelay() {
        return this.retryDelay;
    }

    public void setRetryDelay(int retryDelay) {
        this.retryDelay = retryDelay;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public long getPoolMaxWaitTime() {
        return this.poolMaxWaitTime;
    }

    public void setPoolMaxWaitTime(int poolMaxWaitTime) {
        this.poolMaxWaitTime = poolMaxWaitTime;
    }

    @Override
    protected void startAppender() {
        final AddressResolver addressResolver = new AddressResolver(this.getGraylogHost());
        this.connectionPool = new SimpleObjectPool<TcpConnection>(new PooledObjectFactory<TcpConnection>(){

            @Override
            public TcpConnection newInstance() {
                return new TcpConnection(GelfTcpAppender.this.initSocketFactory(), addressResolver, GelfTcpAppender.this.getGraylogPort(), GelfTcpAppender.this.connectTimeout);
            }
        }, this.poolSize, this.poolMaxWaitTime, this.reconnectInterval);
    }

    protected SocketFactory initSocketFactory() {
        return SocketFactory.getDefault();
    }

    @Override
    protected void appendMessage(byte[] messageToSend) {
        byte[] tcpMessage = Arrays.copyOf(messageToSend, messageToSend.length + 1);
        int openRetries = this.maxRetries;
        while (!this.sendMessage(tcpMessage)) {
            if (this.retryDelay > 0 && openRetries > 0) {
                try {
                    Thread.sleep(this.retryDelay);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            if (openRetries-- > 0 && this.isStarted()) continue;
        }
    }

    private boolean sendMessage(final byte[] messageToSend) {
        try {
            this.connectionPool.execute(new PooledObjectConsumer<TcpConnection>(){

                @Override
                public void accept(TcpConnection tcpConnection) throws IOException {
                    tcpConnection.write(messageToSend);
                }
            });
        }
        catch (Exception e) {
            this.addError(String.format("Error sending message via tcp://%s:%s", this.getGraylogHost(), this.getGraylogPort()), e);
            return false;
        }
        return true;
    }

    @Override
    protected void close() {
        this.connectionPool.close();
    }
}

