/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.protocol;

import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.spi.InitialContextFactory;
import org.apache.ldap.common.Lockable;
import org.apache.ldap.common.exception.LdapException;
import org.apache.ldap.common.message.BindRequest;
import org.apache.ldap.common.message.BindResponseImpl;
import org.apache.ldap.common.message.Control;
import org.apache.ldap.common.message.LdapResult;
import org.apache.ldap.common.message.LdapResultImpl;
import org.apache.ldap.common.message.MessageTypeEnum;
import org.apache.ldap.common.message.ResultCodeEnum;
import org.apache.ldap.common.util.ExceptionUtils;
import org.apache.ldap.server.configuration.Configuration;
import org.apache.ldap.server.configuration.StartupConfiguration;
import org.apache.ldap.server.protocol.SessionRegistry;
import org.apache.mina.protocol.ProtocolSession;
import org.apache.mina.protocol.handler.MessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindHandler
implements MessageHandler {
    private static final Logger LOG = LoggerFactory.getLogger((Class)(class$org$apache$ldap$server$protocol$BindHandler == null ? (class$org$apache$ldap$server$protocol$BindHandler = BindHandler.class$("org.apache.ldap.server.protocol.BindHandler")) : class$org$apache$ldap$server$protocol$BindHandler));
    private static final Control[] EMPTY = new Control[0];
    static /* synthetic */ Class class$org$apache$ldap$server$protocol$BindHandler;

    public void messageReceived(ProtocolSession session, Object request) {
        LdapContext ctx;
        boolean emptyDn;
        BindRequest req = (BindRequest)request;
        BindResponseImpl resp = new BindResponseImpl(req.getMessageId());
        LdapResultImpl result = new LdapResultImpl((Lockable)resp);
        resp.setLdapResult((LdapResult)result);
        Hashtable env = SessionRegistry.getSingleton().getEnvironment();
        StartupConfiguration cfg = (StartupConfiguration)Configuration.toConfiguration((Hashtable)env);
        if (!req.isSimple()) {
            result.setResultCode(ResultCodeEnum.AUTHMETHODNOTSUPPORTED);
            result.setErrorMessage("Only simple binds currently supported");
            session.write((Object)resp);
            return;
        }
        boolean allowAnonymousBinds = cfg.isAllowAnonymousAccess();
        boolean emptyCredentials = req.getCredentials() == null || req.getCredentials().length == 0;
        boolean bl = emptyDn = req.getName() == null || req.getName().length() == 0;
        if (emptyCredentials && emptyDn && !allowAnonymousBinds) {
            result.setResultCode(ResultCodeEnum.INSUFFICIENTACCESSRIGHTS);
            String msg = "Bind failure: Anonymous binds have been disabled!";
            result.setErrorMessage(msg);
            session.write((Object)resp);
            return;
        }
        String dn = req.getName();
        byte[] creds = req.getCredentials();
        Hashtable cloned = (Hashtable)env.clone();
        cloned.put("java.naming.security.principal", dn);
        cloned.put("java.naming.security.credentials", creds);
        cloned.put("java.naming.security.authentication", "simple");
        Control[] connCtls = req.getControls().toArray(EMPTY);
        try {
            if (cloned.containsKey("server.use.factory.instance")) {
                InitialContextFactory factory = (InitialContextFactory)cloned.get("server.use.factory.instance");
                if (factory == null) {
                    throw new NullPointerException("server.use.factory.instance was set in env but was null");
                }
                ctx = (LdapContext)factory.getInitialContext(cloned);
            } else {
                ctx = new InitialLdapContext(cloned, (javax.naming.ldap.Control[])connCtls);
            }
        }
        catch (NamingException e) {
            if (e instanceof LdapException) {
                result.setResultCode(((LdapException)e).getResultCode());
            } else {
                result.setResultCode(ResultCodeEnum.getBestEstimate((Throwable)e, (MessageTypeEnum)req.getType()));
            }
            String msg = "Bind failed";
            if (LOG.isDebugEnabled()) {
                msg = msg + ":\n" + ExceptionUtils.getStackTrace((Throwable)e);
                msg = msg + "\n\nBindRequest = \n" + req.toString();
            }
            result.setErrorMessage(msg);
            session.write((Object)resp);
            return;
        }
        SessionRegistry.getSingleton().setLdapContext(session, ctx);
        result.setResultCode(ResultCodeEnum.SUCCESS);
        result.setMatchedDn(req.getName());
        session.write((Object)resp);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

