/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.protocol;

import javax.naming.NamingException;
import javax.naming.ldap.LdapContext;
import org.apache.ldap.common.Lockable;
import org.apache.ldap.common.exception.LdapException;
import org.apache.ldap.common.message.DeleteRequest;
import org.apache.ldap.common.message.DeleteResponseImpl;
import org.apache.ldap.common.message.LdapResult;
import org.apache.ldap.common.message.LdapResultImpl;
import org.apache.ldap.common.message.MessageTypeEnum;
import org.apache.ldap.common.message.ResultCodeEnum;
import org.apache.ldap.common.util.ExceptionUtils;
import org.apache.ldap.server.protocol.SessionRegistry;
import org.apache.mina.protocol.ProtocolSession;
import org.apache.mina.protocol.handler.MessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteHandler
implements MessageHandler {
    private static final Logger LOG = LoggerFactory.getLogger((Class)(class$org$apache$ldap$server$protocol$DeleteHandler == null ? (class$org$apache$ldap$server$protocol$DeleteHandler = DeleteHandler.class$("org.apache.ldap.server.protocol.DeleteHandler")) : class$org$apache$ldap$server$protocol$DeleteHandler));
    static /* synthetic */ Class class$org$apache$ldap$server$protocol$DeleteHandler;

    public void messageReceived(ProtocolSession session, Object request) {
        DeleteRequest req = (DeleteRequest)request;
        DeleteResponseImpl resp = new DeleteResponseImpl(req.getMessageId());
        resp.setLdapResult((LdapResult)new LdapResultImpl((Lockable)resp));
        try {
            LdapContext ctx = SessionRegistry.getSingleton().getLdapContext(session, null, true);
            ctx.destroySubcontext(req.getName());
        }
        catch (NamingException e) {
            String msg = "failed to delete entry " + req.getName();
            if (LOG.isDebugEnabled()) {
                msg = msg + ":\n" + ExceptionUtils.getStackTrace((Throwable)e);
            }
            ResultCodeEnum code = e instanceof LdapException ? ((LdapException)e).getResultCode() : ResultCodeEnum.getBestEstimate((Throwable)e, (MessageTypeEnum)req.getType());
            resp.getLdapResult().setResultCode(code);
            resp.getLdapResult().setErrorMessage(msg);
            if (e.getResolvedName() != null) {
                resp.getLdapResult().setMatchedDn(e.getResolvedName().toString());
            }
            session.write((Object)resp);
            return;
        }
        resp.getLdapResult().setResultCode(ResultCodeEnum.SUCCESS);
        resp.getLdapResult().setMatchedDn(req.getName());
        session.write((Object)resp);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

