/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.protocol;

import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.asn1.codec.mina.Asn1CodecDecoder;
import org.apache.asn1.codec.mina.Asn1CodecEncoder;
import org.apache.asn1.codec.stateful.StatefulDecoder;
import org.apache.asn1.codec.stateful.StatefulEncoder;
import org.apache.ldap.common.exception.LdapNamingException;
import org.apache.ldap.common.message.MessageDecoder;
import org.apache.ldap.common.message.MessageEncoder;
import org.apache.ldap.common.message.ResultCodeEnum;
import org.apache.ldap.server.protocol.SessionRegistry;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.protocol.ProtocolCodecFactory;
import org.apache.mina.protocol.ProtocolDecoder;
import org.apache.mina.protocol.ProtocolEncoder;
import org.apache.mina.protocol.ProtocolHandler;
import org.apache.mina.protocol.ProtocolProvider;
import org.apache.mina.protocol.ProtocolSession;
import org.apache.mina.protocol.handler.DemuxingProtocolHandler;
import org.apache.mina.protocol.handler.MessageHandler;

public class LdapProtocolProvider
implements ProtocolProvider {
    public static final String SERVICE_NAME = "ldap";
    public static final Map DEFAULT_HANDLERS;
    private final ProtocolCodecFactory codecFactory;
    private final LdapProtocolHandler handler = new LdapProtocolHandler();
    static /* synthetic */ Class class$org$apache$ldap$common$message$AbandonRequest;
    static /* synthetic */ Class class$org$apache$ldap$server$protocol$AbandonHandler;
    static /* synthetic */ Class class$org$apache$ldap$common$message$AbandonRequestImpl;
    static /* synthetic */ Class class$org$apache$ldap$common$message$AddRequest;
    static /* synthetic */ Class class$org$apache$ldap$server$protocol$AddHandler;
    static /* synthetic */ Class class$org$apache$ldap$common$message$AddRequestImpl;
    static /* synthetic */ Class class$org$apache$ldap$common$message$BindRequest;
    static /* synthetic */ Class class$org$apache$ldap$server$protocol$BindHandler;
    static /* synthetic */ Class class$org$apache$ldap$common$message$BindRequestImpl;
    static /* synthetic */ Class class$org$apache$ldap$common$message$CompareRequest;
    static /* synthetic */ Class class$org$apache$ldap$server$protocol$CompareHandler;
    static /* synthetic */ Class class$org$apache$ldap$common$message$CompareRequestImpl;
    static /* synthetic */ Class class$org$apache$ldap$common$message$DeleteRequest;
    static /* synthetic */ Class class$org$apache$ldap$server$protocol$DeleteHandler;
    static /* synthetic */ Class class$org$apache$ldap$common$message$DeleteRequestImpl;
    static /* synthetic */ Class class$org$apache$ldap$common$message$ExtendedRequest;
    static /* synthetic */ Class class$org$apache$ldap$server$protocol$ExtendedHandler;
    static /* synthetic */ Class class$org$apache$ldap$common$message$ExtendedRequestImpl;
    static /* synthetic */ Class class$org$apache$ldap$common$message$ModifyRequest;
    static /* synthetic */ Class class$org$apache$ldap$server$protocol$ModifyHandler;
    static /* synthetic */ Class class$org$apache$ldap$common$message$ModifyRequestImpl;
    static /* synthetic */ Class class$org$apache$ldap$common$message$ModifyDnRequest;
    static /* synthetic */ Class class$org$apache$ldap$server$protocol$ModifyDnHandler;
    static /* synthetic */ Class class$org$apache$ldap$common$message$ModifyDnRequestImpl;
    static /* synthetic */ Class class$org$apache$ldap$common$message$SearchRequest;
    static /* synthetic */ Class class$org$apache$ldap$server$protocol$SearchHandler;
    static /* synthetic */ Class class$org$apache$ldap$common$message$SearchRequestImpl;
    static /* synthetic */ Class class$org$apache$ldap$common$message$UnbindRequest;
    static /* synthetic */ Class class$org$apache$ldap$server$protocol$UnbindHandler;
    static /* synthetic */ Class class$org$apache$ldap$common$message$UnbindRequestImpl;

    public LdapProtocolProvider(Hashtable env) throws LdapNamingException {
        Hashtable copy = (Hashtable)env.clone();
        copy.put("java.naming.provider.url", "");
        SessionRegistry.releaseSingleton();
        new SessionRegistry(copy);
        Iterator requestTypes = DEFAULT_HANDLERS.keySet().iterator();
        while (requestTypes.hasNext()) {
            MessageHandler handler = null;
            String type = (String)requestTypes.next();
            Class<?> clazz = null;
            if (copy.containsKey(type)) {
                try {
                    clazz = Class.forName((String)copy.get(type));
                }
                catch (ClassNotFoundException e) {
                    String msg = "failed to load class " + clazz;
                    msg = msg + " for processing " + type + " objects.";
                    LdapNamingException lne = new LdapNamingException(msg, ResultCodeEnum.OTHER);
                    lne.setRootCause((Throwable)e);
                    throw lne;
                }
            } else {
                clazz = (Class<?>)DEFAULT_HANDLERS.get(type);
            }
            try {
                Class<?> typeClass = Class.forName(type);
                handler = (MessageHandler)clazz.newInstance();
                this.handler.registerMessageType(typeClass, handler);
            }
            catch (Exception e) {
                String msg = "failed to create handler instance of " + clazz;
                msg = msg + " for processing " + type + " objects.";
                LdapNamingException lne = new LdapNamingException(msg, ResultCodeEnum.OTHER);
                lne.setRootCause((Throwable)e);
                throw lne;
            }
        }
        this.codecFactory = new ProtocolCodecFactoryImpl(copy);
    }

    public LdapProtocolProvider() throws LdapNamingException {
        SessionRegistry.releaseSingleton();
        new SessionRegistry(null);
        Iterator requestTypes = DEFAULT_HANDLERS.keySet().iterator();
        while (requestTypes.hasNext()) {
            MessageHandler handler = null;
            String type = (String)requestTypes.next();
            Class clazz = null;
            clazz = (Class)DEFAULT_HANDLERS.get(type);
            try {
                Class<?> typeClass = Class.forName(type);
                handler = (MessageHandler)clazz.newInstance();
                this.handler.registerMessageType(typeClass, handler);
            }
            catch (Exception e) {
                String msg = "failed to create handler instance of " + clazz;
                msg = msg + " for processing " + type + " objects.";
                LdapNamingException lne = new LdapNamingException(msg, ResultCodeEnum.OTHER);
                lne.setRootCause((Throwable)e);
                throw lne;
            }
        }
        this.codecFactory = new ProtocolCodecFactoryImpl();
    }

    public String getName() {
        return SERVICE_NAME;
    }

    public ProtocolCodecFactory getCodecFactory() {
        return this.codecFactory;
    }

    public ProtocolHandler getHandler() {
        return this.handler;
    }

    public static void main(String[] args) throws Exception {
        new LdapProtocolProvider();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        HashMap<String, Class> map = new HashMap<String, Class>();
        map.put((class$org$apache$ldap$common$message$AbandonRequest == null ? (class$org$apache$ldap$common$message$AbandonRequest = LdapProtocolProvider.class$("org.apache.ldap.common.message.AbandonRequest")) : class$org$apache$ldap$common$message$AbandonRequest).getName(), class$org$apache$ldap$server$protocol$AbandonHandler == null ? (class$org$apache$ldap$server$protocol$AbandonHandler = LdapProtocolProvider.class$("org.apache.ldap.server.protocol.AbandonHandler")) : class$org$apache$ldap$server$protocol$AbandonHandler);
        map.put((class$org$apache$ldap$common$message$AbandonRequestImpl == null ? (class$org$apache$ldap$common$message$AbandonRequestImpl = LdapProtocolProvider.class$("org.apache.ldap.common.message.AbandonRequestImpl")) : class$org$apache$ldap$common$message$AbandonRequestImpl).getName(), class$org$apache$ldap$server$protocol$AbandonHandler == null ? (class$org$apache$ldap$server$protocol$AbandonHandler = LdapProtocolProvider.class$("org.apache.ldap.server.protocol.AbandonHandler")) : class$org$apache$ldap$server$protocol$AbandonHandler);
        map.put((class$org$apache$ldap$common$message$AddRequest == null ? (class$org$apache$ldap$common$message$AddRequest = LdapProtocolProvider.class$("org.apache.ldap.common.message.AddRequest")) : class$org$apache$ldap$common$message$AddRequest).getName(), class$org$apache$ldap$server$protocol$AddHandler == null ? (class$org$apache$ldap$server$protocol$AddHandler = LdapProtocolProvider.class$("org.apache.ldap.server.protocol.AddHandler")) : class$org$apache$ldap$server$protocol$AddHandler);
        map.put((class$org$apache$ldap$common$message$AddRequestImpl == null ? (class$org$apache$ldap$common$message$AddRequestImpl = LdapProtocolProvider.class$("org.apache.ldap.common.message.AddRequestImpl")) : class$org$apache$ldap$common$message$AddRequestImpl).getName(), class$org$apache$ldap$server$protocol$AddHandler == null ? (class$org$apache$ldap$server$protocol$AddHandler = LdapProtocolProvider.class$("org.apache.ldap.server.protocol.AddHandler")) : class$org$apache$ldap$server$protocol$AddHandler);
        map.put((class$org$apache$ldap$common$message$BindRequest == null ? (class$org$apache$ldap$common$message$BindRequest = LdapProtocolProvider.class$("org.apache.ldap.common.message.BindRequest")) : class$org$apache$ldap$common$message$BindRequest).getName(), class$org$apache$ldap$server$protocol$BindHandler == null ? (class$org$apache$ldap$server$protocol$BindHandler = LdapProtocolProvider.class$("org.apache.ldap.server.protocol.BindHandler")) : class$org$apache$ldap$server$protocol$BindHandler);
        map.put((class$org$apache$ldap$common$message$BindRequestImpl == null ? (class$org$apache$ldap$common$message$BindRequestImpl = LdapProtocolProvider.class$("org.apache.ldap.common.message.BindRequestImpl")) : class$org$apache$ldap$common$message$BindRequestImpl).getName(), class$org$apache$ldap$server$protocol$BindHandler == null ? (class$org$apache$ldap$server$protocol$BindHandler = LdapProtocolProvider.class$("org.apache.ldap.server.protocol.BindHandler")) : class$org$apache$ldap$server$protocol$BindHandler);
        map.put((class$org$apache$ldap$common$message$CompareRequest == null ? (class$org$apache$ldap$common$message$CompareRequest = LdapProtocolProvider.class$("org.apache.ldap.common.message.CompareRequest")) : class$org$apache$ldap$common$message$CompareRequest).getName(), class$org$apache$ldap$server$protocol$CompareHandler == null ? (class$org$apache$ldap$server$protocol$CompareHandler = LdapProtocolProvider.class$("org.apache.ldap.server.protocol.CompareHandler")) : class$org$apache$ldap$server$protocol$CompareHandler);
        map.put((class$org$apache$ldap$common$message$CompareRequestImpl == null ? (class$org$apache$ldap$common$message$CompareRequestImpl = LdapProtocolProvider.class$("org.apache.ldap.common.message.CompareRequestImpl")) : class$org$apache$ldap$common$message$CompareRequestImpl).getName(), class$org$apache$ldap$server$protocol$CompareHandler == null ? (class$org$apache$ldap$server$protocol$CompareHandler = LdapProtocolProvider.class$("org.apache.ldap.server.protocol.CompareHandler")) : class$org$apache$ldap$server$protocol$CompareHandler);
        map.put((class$org$apache$ldap$common$message$DeleteRequest == null ? (class$org$apache$ldap$common$message$DeleteRequest = LdapProtocolProvider.class$("org.apache.ldap.common.message.DeleteRequest")) : class$org$apache$ldap$common$message$DeleteRequest).getName(), class$org$apache$ldap$server$protocol$DeleteHandler == null ? (class$org$apache$ldap$server$protocol$DeleteHandler = LdapProtocolProvider.class$("org.apache.ldap.server.protocol.DeleteHandler")) : class$org$apache$ldap$server$protocol$DeleteHandler);
        map.put((class$org$apache$ldap$common$message$DeleteRequestImpl == null ? (class$org$apache$ldap$common$message$DeleteRequestImpl = LdapProtocolProvider.class$("org.apache.ldap.common.message.DeleteRequestImpl")) : class$org$apache$ldap$common$message$DeleteRequestImpl).getName(), class$org$apache$ldap$server$protocol$DeleteHandler == null ? (class$org$apache$ldap$server$protocol$DeleteHandler = LdapProtocolProvider.class$("org.apache.ldap.server.protocol.DeleteHandler")) : class$org$apache$ldap$server$protocol$DeleteHandler);
        map.put((class$org$apache$ldap$common$message$ExtendedRequest == null ? (class$org$apache$ldap$common$message$ExtendedRequest = LdapProtocolProvider.class$("org.apache.ldap.common.message.ExtendedRequest")) : class$org$apache$ldap$common$message$ExtendedRequest).getName(), class$org$apache$ldap$server$protocol$ExtendedHandler == null ? (class$org$apache$ldap$server$protocol$ExtendedHandler = LdapProtocolProvider.class$("org.apache.ldap.server.protocol.ExtendedHandler")) : class$org$apache$ldap$server$protocol$ExtendedHandler);
        map.put((class$org$apache$ldap$common$message$ExtendedRequestImpl == null ? (class$org$apache$ldap$common$message$ExtendedRequestImpl = LdapProtocolProvider.class$("org.apache.ldap.common.message.ExtendedRequestImpl")) : class$org$apache$ldap$common$message$ExtendedRequestImpl).getName(), class$org$apache$ldap$server$protocol$ExtendedHandler == null ? (class$org$apache$ldap$server$protocol$ExtendedHandler = LdapProtocolProvider.class$("org.apache.ldap.server.protocol.ExtendedHandler")) : class$org$apache$ldap$server$protocol$ExtendedHandler);
        map.put((class$org$apache$ldap$common$message$ModifyRequest == null ? (class$org$apache$ldap$common$message$ModifyRequest = LdapProtocolProvider.class$("org.apache.ldap.common.message.ModifyRequest")) : class$org$apache$ldap$common$message$ModifyRequest).getName(), class$org$apache$ldap$server$protocol$ModifyHandler == null ? (class$org$apache$ldap$server$protocol$ModifyHandler = LdapProtocolProvider.class$("org.apache.ldap.server.protocol.ModifyHandler")) : class$org$apache$ldap$server$protocol$ModifyHandler);
        map.put((class$org$apache$ldap$common$message$ModifyRequestImpl == null ? (class$org$apache$ldap$common$message$ModifyRequestImpl = LdapProtocolProvider.class$("org.apache.ldap.common.message.ModifyRequestImpl")) : class$org$apache$ldap$common$message$ModifyRequestImpl).getName(), class$org$apache$ldap$server$protocol$ModifyHandler == null ? (class$org$apache$ldap$server$protocol$ModifyHandler = LdapProtocolProvider.class$("org.apache.ldap.server.protocol.ModifyHandler")) : class$org$apache$ldap$server$protocol$ModifyHandler);
        map.put((class$org$apache$ldap$common$message$ModifyDnRequest == null ? (class$org$apache$ldap$common$message$ModifyDnRequest = LdapProtocolProvider.class$("org.apache.ldap.common.message.ModifyDnRequest")) : class$org$apache$ldap$common$message$ModifyDnRequest).getName(), class$org$apache$ldap$server$protocol$ModifyDnHandler == null ? (class$org$apache$ldap$server$protocol$ModifyDnHandler = LdapProtocolProvider.class$("org.apache.ldap.server.protocol.ModifyDnHandler")) : class$org$apache$ldap$server$protocol$ModifyDnHandler);
        map.put((class$org$apache$ldap$common$message$ModifyDnRequestImpl == null ? (class$org$apache$ldap$common$message$ModifyDnRequestImpl = LdapProtocolProvider.class$("org.apache.ldap.common.message.ModifyDnRequestImpl")) : class$org$apache$ldap$common$message$ModifyDnRequestImpl).getName(), class$org$apache$ldap$server$protocol$ModifyDnHandler == null ? (class$org$apache$ldap$server$protocol$ModifyDnHandler = LdapProtocolProvider.class$("org.apache.ldap.server.protocol.ModifyDnHandler")) : class$org$apache$ldap$server$protocol$ModifyDnHandler);
        map.put((class$org$apache$ldap$common$message$SearchRequest == null ? (class$org$apache$ldap$common$message$SearchRequest = LdapProtocolProvider.class$("org.apache.ldap.common.message.SearchRequest")) : class$org$apache$ldap$common$message$SearchRequest).getName(), class$org$apache$ldap$server$protocol$SearchHandler == null ? (class$org$apache$ldap$server$protocol$SearchHandler = LdapProtocolProvider.class$("org.apache.ldap.server.protocol.SearchHandler")) : class$org$apache$ldap$server$protocol$SearchHandler);
        map.put((class$org$apache$ldap$common$message$SearchRequestImpl == null ? (class$org$apache$ldap$common$message$SearchRequestImpl = LdapProtocolProvider.class$("org.apache.ldap.common.message.SearchRequestImpl")) : class$org$apache$ldap$common$message$SearchRequestImpl).getName(), class$org$apache$ldap$server$protocol$SearchHandler == null ? (class$org$apache$ldap$server$protocol$SearchHandler = LdapProtocolProvider.class$("org.apache.ldap.server.protocol.SearchHandler")) : class$org$apache$ldap$server$protocol$SearchHandler);
        map.put((class$org$apache$ldap$common$message$UnbindRequest == null ? (class$org$apache$ldap$common$message$UnbindRequest = LdapProtocolProvider.class$("org.apache.ldap.common.message.UnbindRequest")) : class$org$apache$ldap$common$message$UnbindRequest).getName(), class$org$apache$ldap$server$protocol$UnbindHandler == null ? (class$org$apache$ldap$server$protocol$UnbindHandler = LdapProtocolProvider.class$("org.apache.ldap.server.protocol.UnbindHandler")) : class$org$apache$ldap$server$protocol$UnbindHandler);
        map.put((class$org$apache$ldap$common$message$UnbindRequestImpl == null ? (class$org$apache$ldap$common$message$UnbindRequestImpl = LdapProtocolProvider.class$("org.apache.ldap.common.message.UnbindRequestImpl")) : class$org$apache$ldap$common$message$UnbindRequestImpl).getName(), class$org$apache$ldap$server$protocol$UnbindHandler == null ? (class$org$apache$ldap$server$protocol$UnbindHandler = LdapProtocolProvider.class$("org.apache.ldap.server.protocol.UnbindHandler")) : class$org$apache$ldap$server$protocol$UnbindHandler);
        DEFAULT_HANDLERS = Collections.unmodifiableMap(map);
    }

    private class LdapProtocolHandler
    extends DemuxingProtocolHandler {
        private LdapProtocolHandler() {
        }

        public void deregisterMessageType(Class arg0) {
            super.deregisterMessageType(arg0);
        }

        public void registerMessageType(Class arg0, MessageHandler arg1) {
            super.registerMessageType(arg0, arg1);
        }

        public void sessionClosed(ProtocolSession session) {
            SessionRegistry.getSingleton().remove(session);
        }

        public void exceptionCaught(ProtocolSession session, Throwable cause) {
            cause.printStackTrace();
        }

        public void messageSent(ProtocolSession arg0, Object arg1) {
        }

        public void sessionIdle(ProtocolSession arg0, IdleStatus arg1) {
        }

        public void sessionOpened(ProtocolSession arg0) {
        }

        public void sessionCreated(ProtocolSession arg0) {
        }
    }

    private static final class ProtocolCodecFactoryImpl
    implements ProtocolCodecFactory {
        final Hashtable env;

        public ProtocolCodecFactoryImpl() {
            this.env = null;
        }

        ProtocolCodecFactoryImpl(Hashtable env) {
            this.env = env;
        }

        public ProtocolEncoder newEncoder() {
            if (this.env == null || this.env.get("asn.1.berlib.provider") == null) {
                return new Asn1CodecEncoder((StatefulEncoder)new MessageEncoder());
            }
            return new Asn1CodecEncoder((StatefulEncoder)new MessageEncoder(this.env));
        }

        public ProtocolDecoder newDecoder() {
            if (this.env == null || this.env.get("asn.1.berlib.provider") == null) {
                return new Asn1CodecDecoder((StatefulDecoder)new MessageDecoder());
            }
            return new Asn1CodecDecoder((StatefulDecoder)new MessageDecoder(this.env));
        }
    }
}

