/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.protocol;

import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.ldap.LdapContext;
import org.apache.ldap.common.Lockable;
import org.apache.ldap.common.exception.LdapException;
import org.apache.ldap.common.message.LdapResult;
import org.apache.ldap.common.message.LdapResultImpl;
import org.apache.ldap.common.message.MessageTypeEnum;
import org.apache.ldap.common.message.ModifyDnRequest;
import org.apache.ldap.common.message.ModifyDnResponseImpl;
import org.apache.ldap.common.message.ResultCodeEnum;
import org.apache.ldap.common.name.LdapName;
import org.apache.ldap.common.util.ExceptionUtils;
import org.apache.ldap.server.protocol.SessionRegistry;
import org.apache.mina.protocol.ProtocolSession;
import org.apache.mina.protocol.handler.MessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyDnHandler
implements MessageHandler {
    private static final Logger LOG = LoggerFactory.getLogger((Class)(class$org$apache$ldap$server$protocol$ModifyDnHandler == null ? (class$org$apache$ldap$server$protocol$ModifyDnHandler = ModifyDnHandler.class$("org.apache.ldap.server.protocol.ModifyDnHandler")) : class$org$apache$ldap$server$protocol$ModifyDnHandler));
    static /* synthetic */ Class class$org$apache$ldap$server$protocol$ModifyDnHandler;

    public void messageReceived(ProtocolSession session, Object request) {
        ModifyDnRequest req = (ModifyDnRequest)request;
        ModifyDnResponseImpl resp = new ModifyDnResponseImpl(req.getMessageId());
        resp.setLdapResult((LdapResult)new LdapResultImpl((Lockable)resp));
        try {
            LdapContext ctx = SessionRegistry.getSingleton().getLdapContext(session, null, true);
            String deleteRDN = String.valueOf(req.getDeleteOldRdn());
            ctx.addToEnvironment("java.naming.ldap.deleteRDN", deleteRDN);
            if (req.isMove()) {
                LdapName oldDn = new LdapName(req.getName());
                LdapName newDn = new LdapName(req.getNewSuperior());
                if (req.getNewRdn() != null) {
                    newDn.add(req.getNewRdn());
                } else {
                    newDn.add(oldDn.getRdn());
                }
                ctx.rename((Name)new LdapName(req.getName()), (Name)newDn);
            } else {
                LdapName newDn = new LdapName(req.getName());
                newDn.remove(newDn.size() - 1);
                newDn.add(req.getNewRdn());
                ctx.rename((Name)new LdapName(req.getName()), (Name)newDn);
            }
        }
        catch (NamingException e) {
            String msg = "failed to modify DN of entry " + req.getName();
            if (LOG.isDebugEnabled()) {
                msg = msg + ":\n" + ExceptionUtils.getStackTrace((Throwable)e);
            }
            ResultCodeEnum code = e instanceof LdapException ? ((LdapException)e).getResultCode() : ResultCodeEnum.getBestEstimate((Throwable)e, (MessageTypeEnum)req.getType());
            resp.getLdapResult().setResultCode(code);
            resp.getLdapResult().setErrorMessage(msg);
            if (e.getResolvedName() != null) {
                resp.getLdapResult().setMatchedDn(e.getResolvedName().toString());
            }
            session.write((Object)resp);
            return;
        }
        resp.getLdapResult().setResultCode(ResultCodeEnum.SUCCESS);
        resp.getLdapResult().setMatchedDn(req.getName());
        session.write((Object)resp);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

