/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.protocol;

import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.ModificationItem;
import javax.naming.ldap.LdapContext;
import org.apache.ldap.common.Lockable;
import org.apache.ldap.common.exception.LdapException;
import org.apache.ldap.common.message.LdapResult;
import org.apache.ldap.common.message.LdapResultImpl;
import org.apache.ldap.common.message.MessageTypeEnum;
import org.apache.ldap.common.message.ModifyRequest;
import org.apache.ldap.common.message.ModifyResponseImpl;
import org.apache.ldap.common.message.ResultCodeEnum;
import org.apache.ldap.common.schema.AttributeType;
import org.apache.ldap.common.schema.ObjectClass;
import org.apache.ldap.common.util.ExceptionUtils;
import org.apache.ldap.server.jndi.ContextFactoryService;
import org.apache.ldap.server.protocol.SessionRegistry;
import org.apache.ldap.server.schema.AttributeTypeRegistry;
import org.apache.ldap.server.schema.ObjectClassRegistry;
import org.apache.ldap.server.schema.OidRegistry;
import org.apache.mina.protocol.ProtocolSession;
import org.apache.mina.protocol.handler.MessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyHandler
implements MessageHandler {
    private static final Logger LOG = LoggerFactory.getLogger((Class)(class$org$apache$ldap$server$protocol$ModifyHandler == null ? (class$org$apache$ldap$server$protocol$ModifyHandler = ModifyHandler.class$("org.apache.ldap.server.protocol.ModifyHandler")) : class$org$apache$ldap$server$protocol$ModifyHandler));
    private static final ModificationItem[] EMPTY = new ModificationItem[0];
    static /* synthetic */ Class class$org$apache$ldap$server$protocol$ModifyHandler;

    public boolean isRequired(String attrId, Attribute objectClass) throws NamingException {
        OidRegistry oidRegistry = ContextFactoryService.getInstance().getConfiguration().getGlobalRegistries().getOidRegistry();
        ObjectClassRegistry registry = ContextFactoryService.getInstance().getConfiguration().getGlobalRegistries().getObjectClassRegistry();
        String attrOid = oidRegistry.getOid(attrId);
        for (int ii = 0; ii < objectClass.size(); ++ii) {
            ObjectClass ocSpec = registry.lookup((String)objectClass.get(ii));
            AttributeType[] mustList = ocSpec.getMustList();
            for (int jj = 0; jj < mustList.length; ++jj) {
                if (!mustList[jj].getOid().equals(attrOid)) continue;
                return true;
            }
        }
        return false;
    }

    public void messageReceived(ProtocolSession session, Object request) {
        ModifyRequest req = (ModifyRequest)request;
        ModifyResponseImpl resp = new ModifyResponseImpl(req.getMessageId());
        resp.setLdapResult((LdapResult)new LdapResultImpl((Lockable)resp));
        try {
            LdapContext ctx = SessionRegistry.getSingleton().getLdapContext(session, null, true);
            Attributes entry = ctx.getAttributes(req.getName());
            ModificationItem[] mods = req.getModificationItems().toArray(EMPTY);
            AttributeTypeRegistry registry = ContextFactoryService.getInstance().getConfiguration().getGlobalRegistries().getAttributeTypeRegistry();
            for (int ii = 0; ii < mods.length; ++ii) {
                ModificationItem item = mods[ii];
                String id = item.getAttribute().getID();
                Attribute attr = entry.get(id);
                if (!registry.hasAttributeType(id)) {
                    resp.getLdapResult().setResultCode(ResultCodeEnum.UNDEFINEDATTRIBUTETYPE);
                    resp.getLdapResult().setMatchedDn(req.getName());
                    session.write((Object)resp);
                    return;
                }
                if (item.getModificationOp() == 3 && attr == null) {
                    resp.getLdapResult().setResultCode(ResultCodeEnum.NOSUCHATTRIBUTE);
                    resp.getLdapResult().setMatchedDn(req.getName());
                    session.write((Object)resp);
                    return;
                }
                if (item.getModificationOp() != 3 || !this.isRequired(id, entry.get("objectClass"))) continue;
                resp.getLdapResult().setResultCode(ResultCodeEnum.OBJECTCLASSVIOLATION);
                resp.getLdapResult().setMatchedDn(req.getName());
                session.write((Object)resp);
                return;
            }
            ctx.modifyAttributes(req.getName(), mods);
        }
        catch (NamingException e) {
            String msg = "failed to modify entry " + req.getName();
            if (LOG.isDebugEnabled()) {
                msg = msg + ":\n" + ExceptionUtils.getStackTrace((Throwable)e);
            }
            ResultCodeEnum code = e instanceof LdapException ? ((LdapException)e).getResultCode() : ResultCodeEnum.getBestEstimate((Throwable)e, (MessageTypeEnum)req.getType());
            resp.getLdapResult().setResultCode(code);
            resp.getLdapResult().setErrorMessage(msg);
            if (e.getResolvedName() != null) {
                resp.getLdapResult().setMatchedDn(e.getResolvedName().toString());
            }
            session.write((Object)resp);
            return;
        }
        resp.getLdapResult().setResultCode(ResultCodeEnum.SUCCESS);
        resp.getLdapResult().setMatchedDn(req.getName());
        session.write((Object)resp);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

