/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.lsh;

import java.io.Serializable;

public abstract class LSH
implements Serializable {
    protected static final long LARGE_PRIME = 433494437L;
    private static final int DEFAULT_STAGES = 3;
    private static final int DEFAULT_BUCKETS = 10;
    private int stages = 3;
    private int buckets = 10;

    public LSH(int stages, int buckets) {
        this.stages = stages;
        this.buckets = buckets;
    }

    public LSH() {
    }

    public final int[] hashSignature(int[] signature) {
        int[] hash = new int[this.stages];
        int rows = signature.length / this.stages;
        for (int i = 0; i < signature.length; ++i) {
            int stage = Math.min(i / rows, this.stages - 1);
            hash[stage] = (int)(((long)hash[stage] + (long)signature[i] * 433494437L) % (long)this.buckets);
        }
        return hash;
    }

    public final int[] hashSignature(boolean[] signature) {
        long[] acc = new long[this.stages];
        for (int i = 0; i < this.stages; ++i) {
            acc[i] = 0L;
        }
        int rows = signature.length / this.stages;
        for (int i = 0; i < signature.length; ++i) {
            long v = 0L;
            if (signature[i]) {
                v = (long)(i + 1) * 433494437L;
            }
            int j = Math.min(i / rows, this.stages - 1);
            acc[j] = (acc[j] + v) % Integer.MAX_VALUE;
        }
        int[] r = new int[this.stages];
        for (int i = 0; i < this.stages; ++i) {
            r[i] = (int)(acc[i] % (long)this.buckets);
        }
        return r;
    }
}

