/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.utils;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseBooleanVector
implements Serializable {
    protected int[] keys;

    public SparseBooleanVector(int size) {
        this.keys = new int[size];
    }

    public SparseBooleanVector() {
        this(20);
    }

    public SparseBooleanVector(HashMap<Integer, Integer> hashmap) {
        this(hashmap.size());
        TreeSet<Integer> sorted_keys = new TreeSet<Integer>(hashmap.keySet());
        int size = 0;
        Iterator i$ = sorted_keys.iterator();
        while (i$.hasNext()) {
            int key;
            this.keys[size] = key = ((Integer)i$.next()).intValue();
            ++size;
        }
    }

    public SparseBooleanVector(boolean[] array) {
        int size = 0;
        for (int i = 0; i < array.length; ++i) {
            if (!array[i]) continue;
            ++size;
        }
        this.keys = new int[size];
        int j = 0;
        for (int i = 0; i < array.length; ++i) {
            if (!array[i]) continue;
            this.keys[j] = i;
            ++j;
        }
    }

    public double jaccard(SparseBooleanVector other) {
        int intersection = this.intersection(other);
        return (double)intersection / (double)(this.size() + other.size() - intersection);
    }

    public int union(SparseBooleanVector other) {
        return this.size() + other.size() - this.intersection(other);
    }

    public int intersection(SparseBooleanVector other) {
        int agg = 0;
        int i = 0;
        int j = 0;
        while (i < this.keys.length && j < other.keys.length) {
            int k1 = this.keys[i];
            int k2 = other.keys[j];
            if (k1 == k2) {
                ++agg;
                ++i;
                ++j;
                continue;
            }
            if (k1 < k2) {
                ++i;
                continue;
            }
            ++j;
        }
        return agg;
    }

    public String toString() {
        String r = "";
        for (int i = 0; i < this.size(); ++i) {
            r = r + this.keys[i] + ":" + this.keys[i] + " ";
        }
        return r;
    }

    public int size() {
        return this.keys.length;
    }
}

