/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.plugins.storage;

import io.appium.java_client.plugins.storage.StorageItem;
import io.appium.java_client.plugins.storage.StorageUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.ErrorCodec;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.codec.AbstractHttpResponseCodec;
import org.openqa.selenium.remote.codec.w3c.W3CHttpResponseCodec;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHeader;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.WebSocket;

public class StorageClient {
    public static final String PREFIX = "/storage";
    private final Json json = new Json();
    private final AbstractHttpResponseCodec responseCodec = new W3CHttpResponseCodec();
    private final ErrorCodec errorCodec = ErrorCodec.createDefault();
    private final URL baseUrl;
    private final HttpClient httpClient;

    public StorageClient(URL baseUrl) {
        this.baseUrl = baseUrl;
        this.httpClient = HttpClient.Factory.createDefault().createClient(baseUrl);
    }

    public StorageClient(ClientConfig clientConfig) {
        this.httpClient = HttpClient.Factory.createDefault().createClient(clientConfig);
        this.baseUrl = clientConfig.baseUrl();
    }

    public void add(File file) {
        this.add(file, file.getName());
    }

    public void add(File file, String name) {
        HttpRequest request = new HttpRequest(HttpMethod.POST, StorageClient.formatPath(this.baseUrl, PREFIX, "add").toString());
        HttpResponse httpResponse = this.httpClient.execute(this.setJsonPayload(request, Map.of("name", name, "sha1", StorageUtils.calcSha1Digest(file))));
        Map value = (Map)this.requireResponseValue(httpResponse);
        Long wsTtlMs = (Long)value.get("ttlMs");
        Map wsInfo = (Map)value.get("ws");
        String streamWsPathname = (String)wsInfo.get("stream");
        String eventWsPathname = (String)wsInfo.get("events");
        CountDownLatch completion = new CountDownLatch(1);
        AtomicReference<Object> lastException = new AtomicReference<Object>(null);
        try (WebSocket streamWs = this.httpClient.openSocket(new HttpRequest(HttpMethod.POST, StorageClient.formatPath(this.baseUrl, streamWsPathname).toString()), new WebSocket.Listener(){});
             WebSocket eventsWs = this.httpClient.openSocket(new HttpRequest(HttpMethod.POST, StorageClient.formatPath(this.baseUrl, eventWsPathname).toString()), (WebSocket.Listener)new EventWsListener(lastException, completion));){
            StorageUtils.streamFileToWebSocket(file, streamWs);
            streamWs.close();
            if (!completion.await(wsTtlMs, TimeUnit.MILLISECONDS)) {
                throw new IllegalStateException(String.format("Could not receive a confirmation about adding '%s' to the server storage within %sms timeout", name, wsTtlMs));
            }
            Throwable exc = lastException.get();
            if (exc != null) {
                throw exc instanceof RuntimeException ? (RuntimeException)exc : new WebDriverException(exc);
            }
        }
        catch (InterruptedException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    public List<StorageItem> list() {
        HttpRequest request = new HttpRequest(HttpMethod.GET, StorageClient.formatPath(this.baseUrl, PREFIX, "list").toString());
        HttpResponse httpResponse = this.httpClient.execute(request);
        List items = (List)this.requireResponseValue(httpResponse);
        return items.stream().map(item -> new StorageItem((String)item.get("name"), (String)item.get("path"), (Long)item.get("size"))).collect(Collectors.toList());
    }

    public boolean delete(String name) {
        HttpRequest request = new HttpRequest(HttpMethod.POST, StorageClient.formatPath(this.baseUrl, PREFIX, "delete").toString());
        HttpResponse httpResponse = this.httpClient.execute(this.setJsonPayload(request, Map.of("name", name)));
        return (Boolean)this.requireResponseValue(httpResponse);
    }

    public void reset() {
        HttpRequest request = new HttpRequest(HttpMethod.POST, StorageClient.formatPath(this.baseUrl, PREFIX, "reset").toString());
        HttpResponse httpResponse = this.httpClient.execute(request);
        this.requireResponseValue(httpResponse);
    }

    private static URL formatPath(URL url, String ... suffixes) {
        if (suffixes.length == 0) {
            return url;
        }
        try {
            URI uri = url.toURI();
            String updatedPath = (uri.getPath() + "/" + String.join((CharSequence)"/", suffixes)).replaceAll("(/{2,})", "/");
            return new URI(uri.getScheme(), uri.getAuthority(), uri.getHost(), uri.getPort(), updatedPath, uri.getQuery(), uri.getFragment()).toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private HttpRequest setJsonPayload(HttpRequest request, Map<String, Object> payload) {
        String strData = this.json.toJson(payload);
        byte[] data = strData.getBytes(StandardCharsets.UTF_8);
        request.setHeader(HttpHeader.ContentLength.getName(), String.valueOf(data.length));
        request.setHeader(HttpHeader.ContentType.getName(), "application/json; charset=utf-8");
        request.setContent(Contents.bytes((byte[])data));
        return request;
    }

    private <T> T requireResponseValue(HttpResponse httpResponse) {
        Response response = this.responseCodec.decode(httpResponse);
        Object value = response.getValue();
        if (value instanceof WebDriverException) {
            throw (WebDriverException)value;
        }
        return (T)response.getValue();
    }

    private final class EventWsListener
    implements WebSocket.Listener {
        private final AtomicReference<Throwable> lastException;
        private final CountDownLatch completion;

        public EventWsListener(AtomicReference<Throwable> lastException, CountDownLatch completion) {
            this.lastException = lastException;
            this.completion = completion;
        }

        public void onBinary(byte[] data) {
            this.extractException(new String(data, StandardCharsets.UTF_8)).ifPresent(this.lastException::set);
            this.completion.countDown();
        }

        public void onText(CharSequence data) {
            this.extractException(data.toString()).ifPresent(this.lastException::set);
            this.completion.countDown();
        }

        public void onError(Throwable cause) {
            this.lastException.set(cause);
            this.completion.countDown();
        }

        private Optional<WebDriverException> extractException(String payload) {
            try {
                Map record = (Map)StorageClient.this.json.toType(payload, Json.MAP_TYPE);
                Map value = (Map)record.get("value");
                if (((Boolean)value.get("success")).booleanValue()) {
                    return Optional.empty();
                }
                return Optional.of(StorageClient.this.errorCodec.decode(record));
            }
            catch (Exception e) {
                return Optional.of(new WebDriverException(payload, (Throwable)e));
            }
        }
    }
}

