/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.service.local;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

class ListOutputStream
extends OutputStream {
    private final List<OutputStream> streams = new ArrayList<OutputStream>();

    ListOutputStream() {
    }

    ListOutputStream add(OutputStream stream) {
        this.streams.add(stream);
        return this;
    }

    Optional<OutputStream> remove(OutputStream stream) {
        return this.streams.remove(stream) ? Optional.of(stream) : Optional.empty();
    }

    @Override
    public void write(int i) throws IOException {
        for (OutputStream stream : this.streams) {
            stream.write(i);
        }
    }

    @Override
    public void write(byte[] var1) throws IOException {
        for (OutputStream stream : this.streams) {
            stream.write(var1, 0, var1.length);
        }
    }

    @Override
    public void write(byte[] var1, int var2, int var3) throws IOException {
        for (OutputStream stream : this.streams) {
            stream.write(var1, var2, var3);
        }
    }

    @Override
    public void flush() throws IOException {
        for (OutputStream stream : this.streams) {
            stream.flush();
        }
    }

    @Override
    public void close() throws IOException {
        for (OutputStream stream : this.streams) {
            stream.close();
        }
    }

    public boolean clear() {
        if (this.streams.isEmpty()) {
            return false;
        }
        this.streams.clear();
        return true;
    }
}

