/*
 * Decompiled with CFR 0.152.
 */
package io.appwrite.cookies;

import android.os.Build;
import android.webkit.CookieManager;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0007\u00a8\u0006\b"}, d2={"removeAll", "", "Landroid/webkit/CookieManager;", "syncToWebKitCookieManager", "Ljava/net/CookieStore;", "toSetCookieString", "", "Ljava/net/HttpCookie;", "library_release"})
@SourceDebugExtension(value={"SMAP\nExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Extensions.kt\nio/appwrite/cookies/ExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n1#2:54\n1855#3,2:55\n*S KotlinDebug\n*F\n+ 1 Extensions.kt\nio/appwrite/cookies/ExtensionsKt\n*L\n40#1:55,2\n*E\n"})
public final class ExtensionsKt {
    @NotNull
    public static final String toSetCookieString(@NotNull HttpCookie $this$toSetCookieString) {
        String secure;
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$toSetCookieString, (String)"<this>");
        if ($this$toSetCookieString.getMaxAge() != -1L) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.UK);
            Cloneable $this$toSetCookieString_u24lambda_u240 = simpleDateFormat;
            boolean bl = false;
            ((DateFormat)$this$toSetCookieString_u24lambda_u240).setTimeZone(TimeZone.getTimeZone("GMT"));
            SimpleDateFormat dateFormat = simpleDateFormat;
            Cloneable $this$toSetCookieString_u24lambda_u241 = $this$toSetCookieString_u24lambda_u240 = Calendar.getInstance(Locale.UK);
            boolean bl2 = false;
            ((Calendar)$this$toSetCookieString_u24lambda_u241).set(13, (int)$this$toSetCookieString.getMaxAge());
            Cloneable calendar = $this$toSetCookieString_u24lambda_u240;
            string = "; expires=" + dateFormat.format(((Calendar)calendar).getTime());
        } else {
            string = "";
        }
        String expires = string;
        String path = $this$toSetCookieString.getPath() != null ? "; path=" + $this$toSetCookieString.getPath() : "";
        String domain = $this$toSetCookieString.getDomain() != null ? "; domain=" + $this$toSetCookieString.getDomain() : "";
        String string2 = secure = $this$toSetCookieString.getSecure() ? "; secure" : "";
        String httpOnly = Build.VERSION.SDK_INT >= 24 ? ($this$toSetCookieString.isHttpOnly() ? "; httponly" : "") : "";
        return $this$toSetCookieString.getName() + '=' + $this$toSetCookieString.getValue() + expires + path + domain + secure + httpOnly;
    }

    public static final synchronized void syncToWebKitCookieManager(@NotNull CookieStore $this$syncToWebKitCookieManager) {
        Intrinsics.checkNotNullParameter((Object)$this$syncToWebKitCookieManager, (String)"<this>");
        CookieManager webKitCookieManager = CookieManager.getInstance();
        List<HttpCookie> list2 = $this$syncToWebKitCookieManager.getCookies();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getCookies(...)");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HttpCookie it = (HttpCookie)element$iv;
            boolean bl = false;
            String hostUrl = (it.getSecure() ? "https" : "http") + "://" + it.getDomain();
            Intrinsics.checkNotNull((Object)it);
            webKitCookieManager.setCookie(hostUrl, ExtensionsKt.toSetCookieString(it));
        }
        webKitCookieManager.flush();
    }

    public static final synchronized void removeAll(@NotNull CookieManager $this$removeAll) {
        Intrinsics.checkNotNullParameter((Object)$this$removeAll, (String)"<this>");
        $this$removeAll.removeAllCookies(null);
        $this$removeAll.flush();
    }
}

