/*
 * Decompiled with CFR 0.152.
 */
package activityconfig;

import activityconfig.yaml.StmtDef;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParsedStmt {
    private static final Pattern stmtToken = Pattern.compile("\\?(\\w+[-_\\d\\w]*)|\\{(\\w+[-_\\d\\w.]*)}");
    private static final Logger logger = LoggerFactory.getLogger(ParsedStmt.class);
    private final StmtDef stmtDef;
    private final String[] spans;
    private final Set<String> missingBindings = new HashSet<String>();
    private final Set<String> extraBindings = new HashSet<String>();
    private final Map<String, String> specificBindings = new LinkedHashMap<String, String>();
    private String anchor;

    public ParsedStmt(StmtDef stmtDef) {
        this.stmtDef = stmtDef;
        this.spans = this.parse();
    }

    public ParsedStmt orError() {
        if (this.hasError()) {
            throw new RuntimeException("Unable to parse statement: " + this.toString());
        }
        return this;
    }

    private String[] parse() {
        ArrayList<String> spans = new ArrayList<String>();
        this.extraBindings.addAll(this.stmtDef.getBindings().keySet());
        String statement = this.stmtDef.getStmt();
        Matcher m = stmtToken.matcher(statement);
        int lastMatch = 0;
        String remainder = "";
        while (m.find(lastMatch)) {
            String pre = statement.substring(lastMatch, m.start());
            String form1 = m.group(1);
            String form2 = m.group(2);
            String tokenName = form1 != null && !form1.isEmpty() ? form1 : form2;
            lastMatch = m.end();
            spans.add(pre);
            if (this.extraBindings.contains(tokenName)) {
                this.specificBindings.put(tokenName, this.stmtDef.getBindings().get(tokenName));
                continue;
            }
            this.missingBindings.add(tokenName);
        }
        this.specificBindings.forEach((k, v) -> this.extraBindings.remove(k));
        if (lastMatch >= 0) {
            spans.add(statement.substring(lastMatch));
        } else {
            spans.add(statement);
        }
        return spans.toArray(new String[0]);
    }

    public String toString() {
        String summary = this.missingBindings.size() > 0 ? "\nundefined bindings:" + this.missingBindings.stream().collect(Collectors.joining(",", "[", "]")) : "";
        return "STMT:" + this.stmtDef.getStmt() + "\n" + summary;
    }

    public boolean hasError() {
        return this.missingBindings.size() > 0;
    }

    public Set<String> getExtraBindings() {
        return this.extraBindings;
    }

    public Set<String> getMissingBindings() {
        return this.missingBindings;
    }

    public Map<String, String> getSpecificBindings() {
        return this.specificBindings;
    }

    public String getPositionalStatement(String anchorToken) {
        StringBuilder sb = new StringBuilder(this.spans[0]);
        for (int i = 1; i < this.spans.length; ++i) {
            sb.append(anchorToken).append(this.spans[i]);
        }
        return sb.toString();
    }

    public String getName() {
        return this.stmtDef.getName();
    }

    public String getStmt() {
        return this.stmtDef.getStmt();
    }

    public Map<String, String> getTags() {
        return this.stmtDef.getTags();
    }

    public Map<String, String> getBindings() {
        return this.stmtDef.getBindings();
    }

    public Map<String, String> getParams() {
        return this.stmtDef.getParams();
    }
}

