/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityapi.cyclelog.buffers;

import java.lang.reflect.Array;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;

public abstract class Buffer<T>
implements Comparable<Buffer<T>> {
    private int position;
    private int limit;
    private T[] data;

    public Buffer(Class<T[]> clazz, int size) {
        this.data = clazz.cast(Array.newInstance(clazz.getComponentType(), size));
        this.limit = this.data.length;
        this.position = 0;
    }

    protected void onFull() {
    }

    protected abstract int compare(T var1, T var2);

    public int position() {
        return this.position;
    }

    public Buffer<T> position(int position) {
        this.position = position;
        return this;
    }

    public int remaining() {
        return this.limit - this.position;
    }

    public Buffer<T> put(T element) {
        if (this.position >= this.limit) {
            throw new BufferOverflowException();
        }
        this.data[this.position++] = element;
        if (this.position == this.limit) {
            this.onFull();
        }
        return this;
    }

    public T get() {
        if (this.position >= this.limit) {
            throw new BufferUnderflowException();
        }
        T got = this.data[this.position++];
        return got;
    }

    public Buffer<T> flip() {
        this.limit = this.position;
        this.position = 0;
        return this;
    }

    @Override
    public int compareTo(Buffer<T> other) {
        int lengthDiff = Integer.compare(this.data.length, other.data.length);
        if (lengthDiff != 0) {
            return lengthDiff;
        }
        int compareTo = Math.min(this.position, other.position);
        for (int pos = 0; pos < compareTo; ++pos) {
            int diff = this.compare(this.data[pos], other.data[pos]);
            if (diff == 0) continue;
            return diff;
        }
        return 0;
    }

    public String toString() {
        return "position=" + this.position + ", limit=" + this.limit + ", capacity=" + (this.data != null ? Integer.valueOf(this.data.length) : "NULLDATA");
    }
}

