/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityapi.cyclelog.inputs.cyclelog;

import io.engineblock.activityapi.core.Activity;
import io.engineblock.activityapi.cyclelog.buffers.results.CycleResult;
import io.engineblock.activityapi.cyclelog.buffers.results.CycleResultsSegment;
import io.engineblock.activityapi.cyclelog.buffers.results.CycleSegment;
import io.engineblock.activityapi.cyclelog.buffers.results.CycleSegmentBuffer;
import io.engineblock.activityapi.cyclelog.buffers.results.ResultReadable;
import io.engineblock.activityapi.cyclelog.buffers.results_rle.CycleResultsRLEBufferReadable;
import io.engineblock.activityapi.cyclelog.inputs.cyclelog.CanFilterResultValue;
import io.engineblock.activityapi.input.Input;
import io.engineblock.util.SimpleConfig;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CycleLogInput
implements Input,
AutoCloseable,
Iterable<CycleResultsSegment>,
CanFilterResultValue {
    private static final Logger logger = LoggerFactory.getLogger(CycleLogInput.class);
    private final Iterator<CycleResultsSegment> cycleResultSegmentIterator;
    private RandomAccessFile raf;
    private MappedByteBuffer mbb;
    private Iterator<CycleResult> segmentIter;
    private Predicate<ResultReadable> filter;

    public CycleLogInput(Activity activity) {
        SimpleConfig conf = new SimpleConfig(activity, "input");
        this.mbb = this.initMappedBuffer(conf.getString("file").orElse(activity.getAlias()) + ".cyclelog");
        this.cycleResultSegmentIterator = this.iterator();
        this.segmentIter = this.cycleResultSegmentIterator.next().iterator();
    }

    public CycleLogInput(String filename) {
        File cycleFile = null;
        try {
            cycleFile = new File(filename);
            if (!cycleFile.exists() && !(cycleFile = new File(cycleFile + ".cyclelog")).exists()) {
                throw new RuntimeException("Cyclelog file does not exist:" + filename);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.mbb = this.initMappedBuffer(cycleFile.getPath());
        this.cycleResultSegmentIterator = new CycleResultsRLEBufferReadable(this.mbb).iterator();
        this.segmentIter = this.cycleResultSegmentIterator.next().iterator();
    }

    @Override
    public void setFilter(Predicate<ResultReadable> filter) {
        this.filter = filter;
    }

    @Override
    public synchronized CycleSegment getInputSegment(int segmentLength) {
        CycleSegmentBuffer csb = new CycleSegmentBuffer(segmentLength);
        while (csb.remaining() > 0) {
            while (!this.segmentIter.hasNext() && this.cycleResultSegmentIterator.hasNext()) {
                this.segmentIter = this.cycleResultSegmentIterator.next().iterator();
            }
            if (this.segmentIter.hasNext()) {
                CycleResult cycleResult = this.segmentIter.next();
                if (this.filter != null && !this.filter.test(cycleResult)) continue;
                csb.append(cycleResult.getCycle());
                continue;
            }
            if (csb.remaining() != segmentLength) break;
            return null;
        }
        return csb.toReadable();
    }

    private MappedByteBuffer initMappedBuffer(String filename) {
        File filepath = new File(filename);
        if (!filepath.exists()) {
            throw new RuntimeException("file path '" + filename + "' does not exist!");
        }
        try {
            this.raf = new RandomAccessFile(filepath, "r");
            this.mbb = this.raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, this.raf.length());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.mbb;
    }

    @Override
    public void close() throws Exception {
        if (this.raf != null) {
            this.raf.close();
            this.mbb = null;
        }
    }

    @Override
    public Iterator<CycleResultsSegment> iterator() {
        CycleResultsRLEBufferReadable cycleResultsSegments = new CycleResultsRLEBufferReadable(this.mbb.duplicate());
        if (cycleResultsSegments instanceof CanFilterResultValue) {
            ((CanFilterResultValue)((Object)cycleResultsSegments)).setFilter(this.filter);
        }
        return cycleResultsSegments.iterator();
    }
}

