/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityapi.rates;

import io.engineblock.activityimpl.ParameterMap;
import io.engineblock.util.Unit;

public class RateSpec {
    public double opsPerSec = 1.0;
    public double burstRatio = 1.1;
    public boolean reportCoDelay = false;

    public RateSpec(double opsPerSec) {
        this(opsPerSec, 0.0, false);
    }

    public RateSpec(double opsPerSec, double burstRatio) {
        this(opsPerSec, burstRatio, false);
    }

    public RateSpec(double opsPerSec, double burstRatio, boolean reportCoDelay) {
        this.opsPerSec = opsPerSec;
        this.burstRatio = burstRatio;
        this.reportCoDelay = reportCoDelay;
    }

    public RateSpec(ParameterMap.NamedParameter tuple) {
        this(tuple.value);
        if (tuple.name.startsWith("co_")) {
            this.reportCoDelay = true;
        }
    }

    public RateSpec(String spec) {
        String[] specs = spec.split("[,:;]");
        switch (specs.length) {
            case 3: {
                this.reportCoDelay = specs[2].toLowerCase().matches("co|true|report");
            }
            case 2: {
                this.burstRatio = Double.valueOf(specs[1]);
            }
            case 1: {
                this.opsPerSec = Unit.doubleCountFor(specs[0]).orElseThrow(() -> new RuntimeException("Unparsable:" + specs[0]));
                break;
            }
            default: {
                throw new RuntimeException("Rate specs must be either '<rate>' or '<rate>:<burstRatio>' as in 5000.0 or 5000.0:1.0");
            }
        }
    }

    public String toString() {
        return "rate:" + this.opsPerSec + ", burst:" + this.burstRatio + ", report:" + this.reportCoDelay;
    }

    public RateSpec withOpsPerSecond(double rate) {
        return new RateSpec(rate, this.burstRatio, this.reportCoDelay);
    }

    public RateSpec withReportCoDelay(boolean reportCoDelay) {
        return new RateSpec(this.opsPerSec, this.burstRatio, reportCoDelay);
    }

    public RateSpec withBurstRatio(double burstRatio) {
        return new RateSpec(this.opsPerSec, burstRatio, this.reportCoDelay);
    }

    public long getCalculatedBurstNanos() {
        if (this.burstRatio == 0.0) {
            return 0L;
        }
        if (this.burstRatio < 1.0) {
            throw new RuntimeException("burst ratio must be either 0.0 (disabled), or be greater or equal to 1.0");
        }
        return (long)(1.0E9 / (this.burstRatio * this.opsPerSec));
    }

    public long getCalculatedNanos() {
        return (long)(1.0E9 / this.opsPerSec);
    }

    public double getRate() {
        return this.opsPerSec;
    }

    public double getBurstRatio() {
        return this.burstRatio;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RateSpec rateSpec = (RateSpec)o;
        if (Double.compare(rateSpec.opsPerSec, this.opsPerSec) != 0) {
            return false;
        }
        if (Double.compare(rateSpec.burstRatio, this.burstRatio) != 0) {
            return false;
        }
        return this.reportCoDelay == rateSpec.reportCoDelay;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.opsPerSec);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.burstRatio);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.reportCoDelay ? 1 : 0);
        return result;
    }

    public boolean getReportCoDelay() {
        return this.reportCoDelay;
    }
}

