/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityimpl.motor;

import java.util.LinkedHashMap;
import java.util.Map;

public class ParamsParser {
    public static Map<String, String> parse(String input) {
        ParseState s = ParseState.expectingName;
        LinkedHashMap<String, String> parms = new LinkedHashMap<String, String>();
        StringBuilder varname = new StringBuilder(128);
        StringBuilder value = new StringBuilder(128);
        boolean isEscaped = false;
        block16: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (isEscaped) {
                switch (s) {
                    case expectingVal: 
                    case readingDquotedVal: 
                    case readingSquotedVal: 
                    case readingRawVal: {
                        value.append(c);
                        break;
                    }
                    case readingName: {
                        varname.append(c);
                        break;
                    }
                    default: {
                        throw new RuntimeException("invalid position for escape:" + i + ", in " + input);
                    }
                }
                isEscaped = false;
                continue;
            }
            switch (s) {
                case expectingName: {
                    if (c == ' ' || c == ';') continue block16;
                    s = ParseState.readingName;
                    varname.append(c);
                    continue block16;
                }
                case readingName: {
                    if (c == '\\') {
                        isEscaped = true;
                        continue block16;
                    }
                    if (c != '=') {
                        varname.append(c);
                        continue block16;
                    }
                    s = ParseState.expectingVal;
                    continue block16;
                }
                case expectingVal: {
                    if (c == '\\') {
                        isEscaped = true;
                        continue block16;
                    }
                    if (c == '\'') {
                        s = ParseState.readingSquotedVal;
                        continue block16;
                    }
                    if (c == '\"') {
                        s = ParseState.readingDquotedVal;
                        continue block16;
                    }
                    if (c == ';') {
                        parms.put(varname.toString(), null);
                        varname.setLength(0);
                        s = ParseState.expectingName;
                        continue block16;
                    }
                    s = ParseState.readingRawVal;
                    value.append(c);
                    continue block16;
                }
                case readingRawVal: {
                    if (c == '\\') {
                        isEscaped = true;
                        continue block16;
                    }
                    if (c != ';') {
                        value.append(c);
                        continue block16;
                    }
                    parms.put(varname.toString(), value.toString());
                    varname.setLength(0);
                    value.setLength(0);
                    s = ParseState.expectingName;
                    continue block16;
                }
                case readingSquotedVal: {
                    if (c == '\\') {
                        isEscaped = true;
                        continue block16;
                    }
                    if (c != '\'') {
                        value.append(c);
                        continue block16;
                    }
                    parms.put(varname.toString(), value.toString());
                    varname.setLength(0);
                    value.setLength(0);
                    s = ParseState.expectingName;
                    continue block16;
                }
                case readingDquotedVal: {
                    if (c == '\\') {
                        isEscaped = true;
                        continue block16;
                    }
                    if (c != '\"') {
                        value.append(c);
                        continue block16;
                    }
                    parms.put(varname.toString(), value.toString());
                    varname.setLength(0);
                    value.setLength(0);
                    s = ParseState.expectingName;
                    continue block16;
                }
                default: {
                    throw new RuntimeException("Unmatched parse state. This should be impossible.");
                }
            }
        }
        if (isEscaped) {
            throw new RuntimeException("an unfinished escape sequence at the end is not valid");
        }
        switch (s) {
            case expectingVal: {
                parms.put(varname.toString(), null);
                varname.setLength(0);
                s = ParseState.expectingName;
                break;
            }
            case readingRawVal: {
                parms.put(varname.toString(), value.toString());
                varname.setLength(0);
                s = ParseState.expectingName;
                break;
            }
        }
        if (input.length() > 0 && parms.size() == 0) {
            throw new RuntimeException("Unable to parse input:" + input);
        }
        return parms;
    }

    private static enum ParseState {
        expectingName,
        readingName,
        expectingVal,
        readingRawVal,
        readingSquotedVal,
        readingDquotedVal;

    }
}

