/*
 * Decompiled with CFR 0.152.
 */
package activityconfig.rawyaml;

import activityconfig.rawyaml.RawStmtsBlock;
import activityconfig.rawyaml.RawStmtsDoc;
import activityconfig.rawyaml.RawStmtsDocList;
import io.engineblock.activityimpl.ActivityInitializationError;
import io.engineblock.util.EngineBlockFiles;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.Constructor;

public class RawYamlStatementLoader {
    private static final Logger logger = LoggerFactory.getLogger(RawYamlStatementLoader.class);
    List<Function<String, String>> imageTransformers = new ArrayList<Function<String, String>>();
    List<Function<String, String>> stringTransformers = new ArrayList<Function<String, String>>();

    public RawStmtsDocList load(String fromPath, String ... searchPaths) {
        InputStream stream = EngineBlockFiles.findRequiredStreamOrFile(fromPath, "yaml", searchPaths);
        String data = "";
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(stream));){
            data = buffer.lines().collect(Collectors.joining("\n"));
        }
        catch (Exception e) {
            throw new RuntimeException("Error while reading yaml stream data:" + e);
        }
        for (Function<String, String> xform : this.stringTransformers) {
            try {
                logger.debug("Applying string transformer to yaml data:" + xform);
                data = xform.apply(data);
            }
            catch (Exception e) {
                ActivityInitializationError t = new ActivityInitializationError("Error applying string transform to input", e);
                logger.error(t.getMessage(), t);
                throw t;
            }
        }
        Yaml yaml = this.getCustomYaml();
        try {
            Iterable<Object> objects = yaml.loadAll(data);
            ArrayList<RawStmtsDoc> stmtListList = new ArrayList<RawStmtsDoc>();
            for (Object object : objects) {
                RawStmtsDoc tgsd = (RawStmtsDoc)object;
                stmtListList.add(tgsd);
            }
            return new RawStmtsDocList(stmtListList);
        }
        catch (Exception e) {
            logger.error("Error loading yaml from " + fromPath, e);
            throw e;
        }
    }

    private Yaml getCustomYaml() {
        Constructor constructor = new Constructor(RawStmtsDoc.class);
        TypeDescription tds = new TypeDescription(RawStmtsDoc.class);
        tds.putListPropertyType("blocks", RawStmtsBlock.class);
        constructor.addTypeDescription(tds);
        return new Yaml(constructor);
    }
}

