/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityapi.cycletracking.buffers.results;

import io.engineblock.activityapi.cycletracking.buffers.results.CycleResult;
import io.engineblock.activityapi.cycletracking.buffers.results.CycleResultsSegment;
import java.util.Arrays;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class CycleResultsIntervalSegment
implements CycleResultsSegment {
    public long cycle;
    public byte[] codes;

    public static CycleResultsIntervalSegment forData(long cycle, byte[] buffer, int offset, int len) {
        CycleResultsIntervalSegment s = new CycleResultsIntervalSegment();
        s.cycle = cycle;
        s.codes = Arrays.copyOfRange(buffer, offset, offset + len);
        return s;
    }

    public static CycleResultsIntervalSegment forData(long cycle, byte[] buffer) {
        CycleResultsIntervalSegment s = new CycleResultsIntervalSegment();
        s.cycle = cycle;
        s.codes = buffer;
        return s;
    }

    @Override
    @NotNull
    public Iterator<CycleResult> iterator() {
        return new CycleSegmentIterator();
    }

    @Override
    public long getCount() {
        return this.codes.length;
    }

    @Override
    public long getMinCycle() {
        return this.cycle;
    }

    public String toString() {
        return "CycleSegment{cycle=" + this.cycle + ", codes=" + (this.codes.length < 100 ? Arrays.toString(this.codes) : Arrays.toString(Arrays.copyOfRange(this.codes, 0, 100))) + '}';
    }

    private class CycleSegmentResult
    implements CycleResult {
        private final long cycle;
        private final int result;

        public CycleSegmentResult(long cycle, int result) {
            this.cycle = cycle;
            this.result = result;
        }

        @Override
        public long getCycle() {
            return this.cycle;
        }

        @Override
        public int getResult() {
            return this.result;
        }

        public String toString() {
            return "CycleSegmentResult{cycle=" + this.cycle + ", result=" + this.result + '}';
        }
    }

    private class CycleSegmentIterator
    implements Iterator<CycleResult> {
        private int index = 0;

        private CycleSegmentIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < CycleResultsIntervalSegment.this.codes.length;
        }

        @Override
        public CycleResult next() {
            CycleSegmentResult cycleSegmentResult = new CycleSegmentResult(CycleResultsIntervalSegment.this.cycle + (long)this.index, CycleResultsIntervalSegment.this.codes[this.index]);
            ++this.index;
            return cycleSegmentResult;
        }
    }
}

