/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityapi.cycletracking.outputs;

import io.engineblock.activityapi.cycletracking.buffers.results.CycleResultsSegment;
import io.engineblock.activityapi.cycletracking.buffers.results.CycleResultsSegmentReadable;
import io.engineblock.activityapi.output.Output;
import java.util.Collections;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReorderingConcurrentResultBuffer
implements Output {
    private static final Logger logger = LoggerFactory.getLogger(ReorderingConcurrentResultBuffer.class);
    private LinkedList<CycleResultsSegment> segments = new LinkedList();
    private Output downstream;
    private int maxCount = 5000;
    private final int threshold;
    private int currentCount;

    public ReorderingConcurrentResultBuffer(Output downstream, int maxCount, int threshold) {
        this.downstream = downstream;
        this.maxCount = maxCount;
        this.threshold = threshold;
    }

    @Override
    public boolean onCycleResult(long completedCycle, int result) {
        this.onCycleResultSegment(CycleResultsSegmentReadable.forCycleResult(completedCycle, result));
        return true;
    }

    @Override
    public synchronized void onCycleResultSegment(CycleResultsSegment segment) {
        this.segments.add(segment);
        this.currentCount = (int)((long)this.currentCount + segment.getCount());
        if (this.currentCount >= this.threshold) {
            logger.trace("Reordering threshold met: " + this.currentCount + "/" + this.threshold + ", sorting and pushing. (" + this.segments.size() + " segments)");
            Collections.sort(this.segments);
            while (this.currentCount >= this.threshold) {
                CycleResultsSegment head = this.segments.removeFirst();
                this.currentCount = (int)((long)this.currentCount - head.getCount());
                this.downstream.onCycleResultSegment(head);
            }
        }
    }

    @Override
    public synchronized void close() throws Exception {
        logger.trace("closing and flushing " + this.segments.size() + " segments");
        for (CycleResultsSegment segment : this.segments) {
            this.downstream.onCycleResultSegment(segment);
        }
        this.downstream.close();
    }
}

