/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityapi.cycletracking.outputs.cyclelog;

import io.engineblock.activityapi.Activity;
import io.engineblock.activityapi.cycletracking.buffers.results.CycleResult;
import io.engineblock.activityapi.cycletracking.buffers.results.CycleResultsSegment;
import io.engineblock.activityapi.cycletracking.buffers.results_rle.CycleResultsRLEBufferTarget;
import io.engineblock.activityapi.output.Output;
import io.engineblock.util.SimpleConfig;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CycleLogOutput
implements Output {
    private static final Logger logger = LoggerFactory.getLogger(CycleLogOutput.class);
    private final SimpleConfig conf;
    private MappedByteBuffer mbb;
    private RandomAccessFile file;
    private CycleResultsRLEBufferTarget targetBuffer;
    private int extentSizeInSpans;
    private File outputFile;

    public CycleLogOutput(Activity activity) {
        this.conf = new SimpleConfig(activity, "output");
        this.extentSizeInSpans = this.conf.getInteger("extentSize").orElse(1000);
        this.outputFile = new File(this.conf.getString("file").orElse(activity.getAlias()) + ".cyclelog");
        this.targetBuffer = new CycleResultsRLEBufferTarget(this.extentSizeInSpans);
        this.removeIfPresent(this.outputFile);
    }

    private void removeIfPresent(File filename) {
        try {
            if (Files.deleteIfExists(filename.toPath())) {
                logger.warn("removed extant file '" + filename + "'");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean onCycleResult(long completedCycle, int result) {
        return false;
    }

    @Override
    public void onCycleResultSegment(CycleResultsSegment segment) {
        for (CycleResult cycleResult : segment) {
            boolean buffered = this.targetBuffer.onCycleResult(cycleResult);
            if (buffered) continue;
            this.flush();
            this.targetBuffer = new CycleResultsRLEBufferTarget(this.extentSizeInSpans);
            boolean bufferedAfterFlush = this.targetBuffer.onCycleResult(cycleResult);
            if (bufferedAfterFlush) continue;
            throw new RuntimeException("Failed to record result in new target buffer");
        }
    }

    private void flush() {
        ByteBuffer nextFileExtent = this.targetBuffer.toByteBuffer();
        logger.debug("RLE result extent is " + nextFileExtent.remaining() + " bytes (" + nextFileExtent.remaining() / 17 + ") tuples");
        int targetCapacity = (this.mbb == null ? 0 : this.mbb.capacity()) + nextFileExtent.remaining();
        logger.trace("ensuring capacity for " + targetCapacity);
        this.ensureCapacity(targetCapacity);
        this.mbb.put(nextFileExtent);
        logger.trace("extent appended");
        logger.trace("mbb position now at " + this.mbb.position());
    }

    @Override
    public void close() throws Exception {
        this.flush();
        this.mbb.force();
        if (this.file != null) {
            this.file.getFD().sync();
            this.file.close();
            this.file = null;
        }
    }

    private synchronized void ensureCapacity(long newCapacity) {
        try {
            logger.info("resizing marking file from " + (this.mbb == null ? 0 : this.mbb.capacity()) + " to " + newCapacity);
            if (this.file == null) {
                this.file = new RandomAccessFile(this.outputFile, "rw");
                this.file.seek(0L);
                this.mbb = this.file.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, newCapacity);
            } else {
                int pos = this.mbb.position();
                this.file.setLength(newCapacity);
                this.file.seek(pos);
                this.mbb = this.file.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, newCapacity);
                this.mbb.position(pos);
            }
            logger.trace("mbb position now at " + this.mbb.position());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "FileBufferRLEMarker{mbb=" + this.mbb + ", file=" + this.file + ", conf=" + this.conf + '}';
    }
}

