/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityimpl;

import io.engineblock.activityapi.RunState;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlotStateTracker {
    private final AtomicReference<RunState> slotState = new AtomicReference<RunState>(RunState.Uninitialized);
    private static final Logger logger = LoggerFactory.getLogger(SlotStateTracker.class);
    private final long slotId;

    public SlotStateTracker(long slotId) {
        this.slotId = slotId;
    }

    public RunState getSlotState() {
        return this.slotState.get();
    }

    public AtomicReference<RunState> getAtomicSlotState() {
        return this.slotState;
    }

    public synchronized void enterState(RunState to) {
        RunState from = this.slotState.get();
        if (!from.canTransitionTo(to)) {
            throw new RuntimeException("Invalid transition from " + (Object)((Object)from) + " to " + (Object)((Object)to));
        }
        while (!this.slotState.compareAndSet(from, to)) {
            logger.trace("retrying transition from:" + (Object)((Object)from) + " to:" + (Object)((Object)to));
        }
        logger.trace("TRANSITION[" + this.slotId + "]: " + (Object)((Object)from) + " ==> " + (Object)((Object)to));
    }
}

