/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityimpl.input;

import io.engineblock.activityapi.ActivitiesAware;
import io.engineblock.activityapi.Activity;
import io.engineblock.activityapi.input.Input;
import io.engineblock.activityapi.input.InputDispenser;
import io.engineblock.activityapi.input.InputType;
import io.engineblock.util.SimpleConfig;
import java.util.Map;

public class CoreInputDispenser
implements InputDispenser,
ActivitiesAware {
    private Activity activity;
    private Map<String, Activity> activities;
    private Input input;

    public CoreInputDispenser(Activity activity) {
        this.activity = activity;
    }

    @Override
    public Input getInput(long slot) {
        if (this.input == null) {
            this.input = this.createInput(slot);
        }
        return this.input;
    }

    private synchronized Input createInput(long slot) {
        SimpleConfig conf = new SimpleConfig(this.activity, "input");
        String inputType = conf.getString("type").orElse("targetrate");
        InputType inputTypeImpl = InputType.FINDER.getOrThrow(inputType);
        InputDispenser inputDispenser = inputTypeImpl.getInputDispenser(this.activity);
        if (inputDispenser instanceof ActivitiesAware) {
            ((ActivitiesAware)((Object)inputDispenser)).setActivitiesMap(this.activities);
        }
        Input input = inputDispenser.getInput(slot);
        return input;
    }

    @Override
    public void setActivitiesMap(Map<String, Activity> activities) {
        this.activities = activities;
    }
}

