/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;

public class EngineBlockFiles {
    public static InputStream findRequiredStreamOrFile(String basename, String extension, String ... searchPaths) {
        Optional<InputStream> optionalStreamOrFile = EngineBlockFiles.findOptionalStreamOrFile(basename, extension, searchPaths);
        return optionalStreamOrFile.orElseThrow(() -> new RuntimeException("Unable to find " + basename + " with extension " + extension + " in file system or in classpath, with search paths: " + Arrays.stream(searchPaths).collect(Collectors.joining(","))));
    }

    public static Optional<InputStream> findOptionalStreamOrFile(final String basename, String extension, final String ... searchPaths) {
        boolean needsExtension = extension != null && !extension.isEmpty() && !basename.endsWith("." + extension);
        final String filename = basename + (needsExtension ? "." + extension : "");
        ArrayList<String> paths = new ArrayList<String>(){
            {
                this.add(filename);
                if (!EngineBlockFiles.isRemote(basename)) {
                    this.addAll(Arrays.stream(searchPaths).map(s -> s + File.separator + filename).collect(Collectors.toCollection(ArrayList::new)));
                }
            }
        };
        for (String path : paths) {
            Optional<InputStream> stream = EngineBlockFiles.getInputStream(path);
            if (!stream.isPresent()) continue;
            return stream;
        }
        return Optional.empty();
    }

    private static boolean isRemote(String path) {
        return path.toLowerCase().startsWith("http:") || path.toLowerCase().startsWith("https:");
    }

    public static Optional<InputStream> getInputStream(String path) {
        if (EngineBlockFiles.isRemote(path)) {
            try {
                URL url = new URL(path);
                InputStream inputStream = url.openStream();
                if (inputStream != null) {
                    return Optional.of(inputStream);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            FileInputStream stream = new FileInputStream(path);
            return Optional.of(stream);
        }
        catch (FileNotFoundException stream) {
            ClassLoader classLoader = EngineBlockFiles.class.getClassLoader();
            InputStream stream2 = classLoader.getResourceAsStream(path);
            if (stream2 != null) {
                return Optional.of(stream2);
            }
            return Optional.empty();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readFile(String basename) {
        InputStream requiredStreamOrFile = EngineBlockFiles.findRequiredStreamOrFile(basename, "", new String[0]);
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(requiredStreamOrFile));){
            String filedata;
            String string = filedata = buffer.lines().collect(Collectors.joining("\n"));
            return string;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error while reading required file to string", ioe);
        }
    }
}

