/*
 * Decompiled with CFR 0.152.
 */
package activityconfig;

import activityconfig.yaml.StmtDef;
import io.virtdata.templates.BindPoint;
import io.virtdata.templates.ParsedTemplate;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParsedStmt {
    private static final Pattern stmtToken = Pattern.compile("\\?(\\w+[-_\\d\\w]*)|\\{(\\w+[-_\\d\\w.]*)}");
    private static final Logger logger = LoggerFactory.getLogger(ParsedStmt.class);
    private ParsedTemplate template;
    private final StmtDef stmtDef;
    private final ParsedTemplate parsed;

    public ParsedStmt(StmtDef stmtDef) {
        this.stmtDef = stmtDef;
        this.parsed = new ParsedTemplate(stmtDef.getStmt(), stmtDef.getBindings());
    }

    public ParsedStmt orError() {
        if (this.hasError()) {
            throw new RuntimeException("Unable to parse statement: " + this.toString());
        }
        return this;
    }

    public String toString() {
        return this.parsed.toString();
    }

    public boolean hasError() {
        return this.parsed.hasError();
    }

    public Set<String> getExtraBindings() {
        return this.parsed.getExtraBindings();
    }

    public Set<String> getMissingBindings() {
        return this.parsed.getMissingBindings();
    }

    public Map<String, String> getSpecificBindings() {
        return this.parsed.getSpecificBindings();
    }

    public String getPositionalStatement(Function<String, String> tokenMapper) {
        return this.parsed.getPositionalStatement(tokenMapper);
    }

    public String getName() {
        return this.stmtDef.getName();
    }

    public String getStmt() {
        return this.stmtDef.getStmt();
    }

    public Map<String, String> getTags() {
        return this.stmtDef.getTags();
    }

    public Map<String, String> getBindings() {
        return this.stmtDef.getBindings();
    }

    public Map<String, String> getParams() {
        return this.stmtDef.getParams();
    }

    public List<BindPoint> getBindPoints() {
        return this.parsed.getBindPoints();
    }
}

