/*
 * Decompiled with CFR 0.152.
 */
package activityconfig.yaml;

import activityconfig.rawyaml.RawStmtsBlock;
import activityconfig.rawyaml.RawStmtsDoc;
import activityconfig.yaml.StmtDef;
import activityconfig.yaml.StmtsBlock;
import io.engineblock.util.Tagged;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class StmtsDoc
implements Tagged,
Iterable<StmtsBlock> {
    private RawStmtsDoc rawStmtsDoc;

    public StmtsDoc(RawStmtsDoc rawStmtsDoc) {
        this.rawStmtsDoc = rawStmtsDoc;
    }

    public List<StmtsBlock> getBlocks() {
        ArrayList<StmtsBlock> blocks = new ArrayList<StmtsBlock>();
        int blockIdx = 0;
        for (RawStmtsBlock rawStmtsBlock : this.rawStmtsDoc.getBlocks()) {
            String compositeName = this.rawStmtsDoc.getName() + (String)(rawStmtsBlock.getName().isEmpty() ? "" : "-" + rawStmtsBlock.getName());
            StmtsBlock compositeBlock = new StmtsBlock(rawStmtsBlock, this, ++blockIdx);
            blocks.add(compositeBlock);
        }
        return blocks;
    }

    @Override
    public Map<String, String> getTags() {
        return this.rawStmtsDoc.getTags();
    }

    public Map<String, String> getParams() {
        return this.rawStmtsDoc.getParams();
    }

    public Map<String, String> getBindings() {
        return this.rawStmtsDoc.getBindings();
    }

    public String getName() {
        return this.rawStmtsDoc.getName();
    }

    public List<StmtDef> getStmts() {
        return this.getBlocks().stream().flatMap(b -> b.getStmts().stream()).collect(Collectors.toList());
    }

    @Override
    public Iterator<StmtsBlock> iterator() {
        return this.getBlocks().iterator();
    }
}

