/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityapi.core;

import io.engineblock.activityapi.core.ActionDispenser;
import io.engineblock.activityapi.core.ActivitiesAware;
import io.engineblock.activityapi.core.Activity;
import io.engineblock.activityapi.core.MotorDispenser;
import io.engineblock.activityapi.input.InputDispenser;
import io.engineblock.activityapi.output.OutputDispenser;
import io.engineblock.activityimpl.ActivityDef;
import io.engineblock.activityimpl.CoreServices;
import io.engineblock.activityimpl.SimpleActivity;
import io.engineblock.activityimpl.action.CoreActionDispenser;
import io.engineblock.activityimpl.motor.CoreMotorDispenser;
import io.engineblock.util.Named;
import io.engineblock.util.SimpleServiceLoader;
import java.util.Map;
import java.util.Optional;

public interface ActivityType<A extends Activity>
extends Named {
    public static final SimpleServiceLoader<ActivityType> FINDER = new SimpleServiceLoader<ActivityType>(ActivityType.class);

    @Override
    public String getName();

    default public A getActivity(ActivityDef activityDef) {
        SimpleActivity activity = new SimpleActivity(activityDef);
        return (A)activity;
    }

    default public Activity getAssembledActivity(ActivityDef activityDef, Map<String, Activity> activities) {
        A activity = this.getActivity(activityDef);
        InputDispenser inputDispenser = this.getInputDispenser(activity);
        if (inputDispenser instanceof ActivitiesAware) {
            ((ActivitiesAware)((Object)inputDispenser)).setActivitiesMap(activities);
        }
        activity.setInputDispenserDelegate(inputDispenser);
        ActionDispenser actionDispenser = this.getActionDispenser(activity);
        if (actionDispenser instanceof ActivitiesAware) {
            ((ActivitiesAware)((Object)actionDispenser)).setActivitiesMap(activities);
        }
        activity.setActionDispenserDelegate(actionDispenser);
        OutputDispenser outputDispenser = this.getOutputDispenser(activity).orElse(null);
        if (outputDispenser != null && outputDispenser instanceof ActivitiesAware) {
            ((ActivitiesAware)((Object)outputDispenser)).setActivitiesMap(activities);
        }
        activity.setOutputDispenserDelegate(outputDispenser);
        MotorDispenser motorDispenser = this.getMotorDispenser(activity, inputDispenser, actionDispenser, outputDispenser);
        if (motorDispenser instanceof ActivitiesAware) {
            ((ActivitiesAware)((Object)motorDispenser)).setActivitiesMap(activities);
        }
        activity.setMotorDispenserDelegate(motorDispenser);
        return activity;
    }

    default public Optional<OutputDispenser> getOutputDispenser(A activity) {
        return CoreServices.getOutputDispenser(activity);
    }

    default public ActionDispenser getActionDispenser(A activity) {
        return new CoreActionDispenser((Activity)activity);
    }

    default public InputDispenser getInputDispenser(A activity) {
        return CoreServices.getInputDispenser(activity);
    }

    default public <T> MotorDispenser<T> getMotorDispenser(A activity, InputDispenser inputDispenser, ActionDispenser actionDispenser, OutputDispenser outputDispenser) {
        return new CoreMotorDispenser((Activity)activity, inputDispenser, actionDispenser, outputDispenser);
    }
}

