/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityapi.cyclelog.buffers.results;

import io.engineblock.activityapi.cyclelog.buffers.results.CycleSegment;
import io.engineblock.activityapi.input.Input;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;

public class CycleArray
implements Input {
    private AtomicInteger offset = new AtomicInteger();
    private long[] cycles;

    public CycleArray(long ... values) {
        this.cycles = values;
    }

    @Override
    public CycleSegment getInputSegment(int segmentLength) {
        int nextOffset;
        int current;
        do {
            if ((nextOffset = (current = this.offset.get()) + segmentLength) <= this.cycles.length) continue;
            return null;
        } while (!this.offset.compareAndSet(current, nextOffset));
        return new ArraySegment(Arrays.copyOfRange(this.cycles, current, nextOffset));
    }

    public static class ArraySegment
    implements CycleSegment {
        private long[] values;
        private int offset = 0;

        public ArraySegment(long[] values) {
            this.values = values;
        }

        @Override
        public long nextCycle() {
            if (this.offset < this.values.length) {
                return this.values[this.offset++];
            }
            return -100L;
        }

        @Override
        public long peekNextCycle() {
            if (this.offset < this.values.length) {
                return this.values[this.offset];
            }
            return -100L;
        }

        @Override
        public boolean isExhausted() {
            return this.offset >= this.values.length;
        }
    }
}

