/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityapi.cyclelog.buffers.results;

import io.engineblock.activityapi.cyclelog.buffers.results.CycleResult;

public class MutableCycleResult
implements CycleResult {
    private final long cycle;
    private int result;
    private long startTimeNanos;
    private long endTimeNanos = Long.MIN_VALUE;
    private long schedulingDelay;

    public MutableCycleResult(long cycle, int result, long startTimeNanos, long schedulingDelay) {
        this.cycle = cycle;
        this.result = result;
        this.startTimeNanos = startTimeNanos;
        this.schedulingDelay = schedulingDelay;
    }

    public MutableCycleResult(long cycle, int result, long startTimeNanos) {
        this(cycle, result, startTimeNanos, Long.MIN_VALUE);
    }

    public MutableCycleResult(long cycle, int result) {
        this(cycle, result, System.nanoTime());
    }

    @Override
    public long getCycle() {
        return this.cycle;
    }

    @Override
    public int getResult() {
        return this.result;
    }

    public String toString() {
        return this.cycle + "->" + this.result;
    }

    public void setResult(int result) {
        this.result = result;
    }

    public long getStartTimeNanos() {
        return this.startTimeNanos;
    }

    public void setStartTimeNanos(long startTimeNanos) {
        this.startTimeNanos = startTimeNanos;
    }

    public long getEndTimeNanos() {
        return this.endTimeNanos;
    }

    public void setEndTimeNanos(long endTimeNanos) {
        this.endTimeNanos = endTimeNanos;
    }

    public long getOpNanos() {
        return this.schedulingDelay + (this.endTimeNanos - this.startTimeNanos);
    }
}

