/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityimpl.motor;

import com.codahale.metrics.Timer;
import io.engineblock.activityapi.core.ops.fluent.opfacets.CompletedOp;
import io.engineblock.activityapi.core.ops.fluent.opfacets.FailedOp;
import io.engineblock.activityapi.core.ops.fluent.opfacets.OpEvents;
import io.engineblock.activityapi.core.ops.fluent.opfacets.OpImpl;
import io.engineblock.activityapi.core.ops.fluent.opfacets.SkippedOp;
import io.engineblock.activityapi.core.ops.fluent.opfacets.StartedOp;
import io.engineblock.activityapi.core.ops.fluent.opfacets.SucceededOp;
import io.engineblock.activityapi.cyclelog.buffers.Buffer;
import io.engineblock.activityapi.cyclelog.buffers.op_output.StrideOutputConsumer;
import io.engineblock.activityapi.cyclelog.buffers.results.CycleResult;
import io.engineblock.activityapi.cyclelog.buffers.results.CycleResultsSegment;
import io.engineblock.activityapi.output.Output;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrideTracker<D>
extends Buffer<CompletedOp<D>>
implements OpEvents<D>,
CycleResultsSegment {
    private static final Logger logger = LoggerFactory.getLogger(StrideTracker.class);
    private final Timer strideServiceTimer;
    private final Timer strideResponseTimer;
    private final OpImpl<Void> strideOp;
    private final Output output;
    private final StrideOutputConsumer<D> outputReader;

    public StrideTracker(Timer strideServiceTimer, Timer strideResponseTimer, long strideWaitTime, long initialCycle, int size, Output output, StrideOutputConsumer<D> outputReader) {
        super(size);
        this.strideServiceTimer = strideServiceTimer;
        this.strideResponseTimer = strideResponseTimer;
        this.strideOp = new OpImpl();
        this.strideOp.setCycle(initialCycle);
        this.strideOp.setWaitTime(strideWaitTime);
        this.output = output;
        this.outputReader = outputReader;
    }

    public void start() {
        this.strideOp.start();
    }

    @Override
    public void onOpStarted(StartedOp<D> op) {
    }

    @Override
    public void onOpSuccess(SucceededOp<D> op) {
        super.put(op);
    }

    @Override
    public void onOpFailure(FailedOp<D> op) {
        super.put(op);
    }

    @Override
    public void onOpSkipped(SkippedOp<D> op) {
        super.put(op);
    }

    @Override
    public void onFull() {
        this.strideOp.succeed(0);
        logger.trace("completed strideOp with first result cycle (" + this.strideOp.getCycle() + ")");
        this.strideServiceTimer.update(this.strideOp.getResponseTimeNanos(), TimeUnit.NANOSECONDS);
        if (this.strideResponseTimer != null) {
            this.strideResponseTimer.update(this.strideOp.getResponseTimeNanos(), TimeUnit.NANOSECONDS);
        }
        if (this.output != null) {
            this.output.onCycleResultSegment(this);
        }
        if (this.outputReader != null) {
            List flippedData = this.getFlippedData();
            this.outputReader.onStrideOutput(flippedData);
        }
    }

    @Override
    protected int compare(CompletedOp<D> one, CompletedOp<D> other) {
        return one.compareTo(other);
    }

    @Override
    public long getCount() {
        return this.data.size();
    }

    @Override
    public long getMinCycle() {
        return ((CompletedOp)this.data.get(0)).getCycle();
    }

    @Override
    public Iterator<CycleResult> iterator() {
        return new CycleResultIterator(this.data.iterator());
    }

    private static final class CycleResultIterator<D>
    implements Iterator<CycleResult> {
        private final Iterator<CompletedOp<D>> copiter;

        public CycleResultIterator(Iterator<CompletedOp<D>> copiter) {
            this.copiter = copiter;
        }

        @Override
        public boolean hasNext() {
            return this.copiter.hasNext();
        }

        @Override
        public CycleResult next() {
            CompletedOp<D> next = this.copiter.next();
            return next;
        }
    }
}

