/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityapi.core;

import io.engineblock.activityapi.core.Activity;
import io.engineblock.activityapi.core.ActivityDefObserver;
import io.engineblock.activityapi.core.AsyncAction;
import io.engineblock.activityapi.core.Stoppable;
import io.engineblock.activityapi.core.ops.fluent.opfacets.TrackedOp;
import io.engineblock.activityimpl.ActivityDef;
import io.engineblock.activityimpl.ParameterMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseAsyncAction<D, A extends Activity>
implements AsyncAction<D>,
Stoppable,
ActivityDefObserver {
    private static final Logger logger = LoggerFactory.getLogger((String)"BaseAsyncAction");
    protected final A activity;
    protected int slot;
    protected boolean running = true;

    public BaseAsyncAction(A activity, int slot) {
        this.activity = activity;
        this.slot = slot;
        this.onActivityDefUpdate(activity.getActivityDef());
    }

    @Override
    public void onActivityDefUpdate(ActivityDef activityDef) {
        ParameterMap params = activityDef.getParams();
        params.getOptionalInteger("async").orElseThrow(() -> new RuntimeException("the async parameter is required to activate async actions"));
    }

    @Override
    public boolean enqueue(TrackedOp<D> opc) {
        this.startOpCycle(opc);
        return this.running;
    }

    public abstract void startOpCycle(TrackedOp<D> var1);

    @Override
    public void requestStop() {
        logger.info(this.toString() + " requested to stop.");
        this.running = false;
    }
}

