/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityapi.ratelimits;

import io.engineblock.activityapi.sysperf.SysPerf;
import io.engineblock.activityapi.sysperf.SysPerfData;
import java.util.concurrent.locks.LockSupport;

public class LeastWorstDelay {
    public static final SysPerfData perfdata = SysPerf.get().getPerfData(false);
    private static final long sleepThreshold = (long)perfdata.getAvgNanos_Thread_Sleep();
    private static final long parkThreshold = (long)perfdata.getAvgNanos_LockSupport_ParkNanos();

    public static void delayAsIfFor(long nanos) {
        if (nanos > 0L) {
            if (nanos > sleepThreshold) {
                nanos -= sleepThreshold;
                try {
                    Thread.sleep(nanos / 1000000L, (int)(nanos % 1000000L));
                }
                catch (InterruptedException interruptedException) {}
            } else if (nanos > parkThreshold) {
                LockSupport.parkNanos(nanos -= parkThreshold);
            }
        }
    }

    public static void debugDelayAsIfFor(long nanos) {
        if (nanos > 0L) {
            if (nanos > sleepThreshold) {
                try {
                    System.out.println(String.format("sleeping for %.9fS", (double)nanos / 1.0E9));
                    Thread.sleep(nanos / 1000000L, (int)(nanos % 1000000L));
                }
                catch (InterruptedException interruptedException) {}
            } else if (nanos > parkThreshold) {
                System.out.println(String.format("parking for %.9fS", (double)nanos / 1.0E9));
                LockSupport.parkNanos(nanos);
            }
        }
    }

    public void delayAsIfUntil(long targetNanoTime) {
        long nanos = Math.max(targetNanoTime - System.nanoTime(), 0L);
        if (nanos > 0L) {
            if (nanos > sleepThreshold) {
                nanos -= sleepThreshold;
                try {
                    Thread.sleep(nanos / 1000000L, (int)(nanos % 1000000L));
                }
                catch (InterruptedException interruptedException) {}
            } else if (nanos > parkThreshold) {
                LockSupport.parkNanos(nanos -= parkThreshold);
            }
        }
    }
}

