/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityapi.ratelimits;

import io.engineblock.activityimpl.ParameterMap;
import io.engineblock.util.Unit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateSpec {
    private static final Logger logger = LoggerFactory.getLogger(RateSpec.class);
    public static final double DEFAULT_RATE_OPS_S = 1.0;
    public static final double DEFAULT_BURST_RATIO = 1.1;
    public static Verb DEFAULT_VERB = Verb.start;
    public double opsPerSec = 1.0;
    public double burstRatio = 1.1;
    public Verb verb = Verb.start;

    public RateSpec(double opsPerSec, double burstRatio) {
        this(opsPerSec, burstRatio, DEFAULT_VERB);
    }

    public RateSpec(double opsPerSec, double burstRatio, Verb type) {
        this.opsPerSec = opsPerSec;
        this.burstRatio = burstRatio;
        this.verb = type;
    }

    public RateSpec(ParameterMap.NamedParameter tuple) {
        this(tuple.value);
        if (tuple.name.startsWith("co_")) {
            logger.warn("The co_ prefix on " + tuple.name + " is no longer needed. All rate limiters now provide standard coordinated omission metrics.");
        }
    }

    public RateSpec(String spec) {
        String[] specs = spec.split("[,:;]");
        switch (specs.length) {
            case 3: {
                this.verb = Verb.valueOf(specs[2].toLowerCase());
                logger.debug("selected rate limiter type: " + this.verb);
            }
            case 2: {
                this.burstRatio = Double.valueOf(specs[1]);
                if (this.burstRatio < 1.0) {
                    throw new RuntimeException("burst ratios less than 1.0 are invalid.");
                }
            }
            case 1: {
                this.opsPerSec = Unit.doubleCountFor(specs[0]).orElseThrow(() -> new RuntimeException("Unparsable:" + specs[0]));
                break;
            }
            default: {
                throw new RuntimeException("Rate specs must be either '<rate>' or '<rate>:<burstRatio>' as in 5000.0 or 5000.0:1.0");
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        double ratePortion = Math.abs(this.opsPerSec - (double)((long)this.opsPerSec));
        String ratefmt = ratePortion > 0.001 ? String.format("%,.3f", this.opsPerSec) : String.format("%,d", (long)this.opsPerSec);
        double br = this.burstRatio * this.opsPerSec;
        double burstPortion = Math.abs(br - (double)((long)br));
        String burstfmt = burstPortion > 0.001 ? String.format("%,.3f", br) : String.format("%,d", (long)br);
        return String.format("rate=%s burstRatio=%.3f (%s SOPSS %s BOPSS) [%s]", new Object[]{ratefmt, this.burstRatio, ratefmt, burstfmt, this.verb});
    }

    public RateSpec withOpsPerSecond(double rate) {
        return new RateSpec(rate, this.burstRatio);
    }

    public RateSpec withBurstRatio(double burstRatio) {
        return new RateSpec(this.opsPerSec, burstRatio);
    }

    public RateSpec withVerb(Verb verb) {
        return new RateSpec(this.opsPerSec, this.burstRatio, verb);
    }

    public long getNanosPerOp() {
        return (long)(1.0E9 / this.opsPerSec);
    }

    public double getRate() {
        return this.opsPerSec;
    }

    public double getBurstRatio() {
        return this.burstRatio;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RateSpec rateSpec = (RateSpec)o;
        if (Double.compare(rateSpec.opsPerSec, this.opsPerSec) != 0) {
            return false;
        }
        return Double.compare(rateSpec.burstRatio, this.burstRatio) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.opsPerSec);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.burstRatio);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public Verb getVerb() {
        return this.verb;
    }

    public boolean isAutoStart() {
        return this.verb == Verb.start || this.verb == Verb.restart;
    }

    public boolean isRestart() {
        return this.verb == Verb.restart;
    }

    public static enum Verb {
        configure,
        start,
        restart;

    }
}

