/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityapi.ratelimits;

import io.engineblock.activityapi.ratelimits.RateSpec;
import io.engineblock.util.Colors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenPool {
    private static final Logger logger = LoggerFactory.getLogger(TokenPool.class);
    public static final double MIN_CONCURRENT_OPS = 2.0;
    private long maxActivePool;
    private long burstPoolSize;
    private long maxOverActivePool;
    private double burstRatio;
    private volatile long activePool;
    private volatile long waitingPool;
    private RateSpec rateSpec;
    private long nanosPerOp;
    private long blocks = 0L;

    public TokenPool(RateSpec rateSpec) {
        this.apply(rateSpec);
        logger.debug("initialized token pool: " + this.toString() + " for rate:" + rateSpec.toString());
    }

    public TokenPool(long poolsize, double burstRatio) {
        this.maxActivePool = poolsize;
        this.burstRatio = burstRatio;
        this.maxOverActivePool = (long)((double)this.maxActivePool * burstRatio);
        this.burstPoolSize = this.maxOverActivePool - this.maxActivePool;
    }

    public synchronized void apply(RateSpec rateSpec) {
        this.rateSpec = rateSpec;
        this.maxActivePool = Math.max(1000000L, (long)((double)rateSpec.getNanosPerOp() * 2.0));
        this.maxOverActivePool = (long)((double)this.maxActivePool * rateSpec.getBurstRatio());
        this.burstRatio = rateSpec.getBurstRatio();
        this.burstPoolSize = this.maxOverActivePool - this.maxActivePool;
        this.nanosPerOp = rateSpec.getNanosPerOp();
        this.notifyAll();
    }

    public double getBurstRatio() {
        return this.burstRatio;
    }

    public synchronized long takeUpTo(long amt) {
        long take = Math.min(amt, this.activePool);
        this.activePool -= take;
        return take;
    }

    public synchronized long blockAndTake() {
        while (this.activePool < this.nanosPerOp) {
            ++this.blocks;
            try {
                this.wait(this.maxActivePool / 1000000L, (int)this.maxActivePool % 1000000);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.activePool -= this.nanosPerOp;
        return this.waitingPool + this.activePool;
    }

    public synchronized long blockAndTake(long tokens) {
        while (this.activePool < tokens) {
            try {
                this.wait(this.maxActivePool / 1000000L, (int)this.maxActivePool % 1000000);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.activePool -= tokens;
        return this.waitingPool + this.activePool;
    }

    public long getWaitTime() {
        return this.activePool + this.waitingPool;
    }

    public long getWaitPool() {
        return this.waitingPool;
    }

    public long getActivePool() {
        return this.activePool;
    }

    public synchronized long refill(long newTokens) {
        boolean debugthis = false;
        long needed = Math.max(this.maxActivePool - this.activePool, 0L);
        long allocatedToActivePool = Math.min(newTokens, needed);
        this.activePool += allocatedToActivePool;
        long allocatedToOverflowPool = newTokens - allocatedToActivePool;
        this.waitingPool += allocatedToOverflowPool;
        double refillFactor = Math.min((double)newTokens / (double)this.maxActivePool, 1.0);
        long burstFillAllowed = (long)(refillFactor * (double)this.burstPoolSize);
        burstFillAllowed = Math.min(this.maxOverActivePool - this.activePool, burstFillAllowed);
        long burstFill = Math.min(burstFillAllowed, this.waitingPool);
        this.waitingPool -= burstFill;
        this.activePool += burstFill;
        if (debugthis) {
            System.out.print(this);
            System.out.print(Colors.ANSI_BrightBlue + " adding=" + allocatedToActivePool);
            if (allocatedToOverflowPool > 0L) {
                System.out.print(Colors.ANSI_Red + " OVERFLOW:" + allocatedToOverflowPool + Colors.ANSI_Reset);
            }
            if (burstFill > 0L) {
                System.out.print(Colors.ANSI_BrightGreen + " BACKFILL:" + burstFill + Colors.ANSI_Reset);
            }
            System.out.println();
        }
        this.notifyAll();
        return this.activePool + this.waitingPool;
    }

    public String toString() {
        return "Tokens: active=" + this.activePool + "/" + this.maxActivePool + String.format(" (%3.1f%%)A (%3.1f%%)B ", (double)this.activePool / (double)this.maxActivePool * 100.0, (double)this.activePool / (double)this.maxOverActivePool * 100.0) + " waiting=" + this.waitingPool + " blocks=" + this.blocks + " rateSpec:" + (this.rateSpec != null ? this.rateSpec.toString() : "NULL");
    }

    public RateSpec getRateSpec() {
        return this.rateSpec;
    }

    public synchronized long restart() {
        long wait = this.activePool + this.waitingPool;
        this.activePool = 0L;
        this.waitingPool = 0L;
        return wait;
    }
}

