/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityimpl;

import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.DoubleSummaryStatistics;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CpuInfo {
    private static final Logger logger = LoggerFactory.getLogger(CpuInfo.class);

    public static Optional<ProcDetails> getProcDetails() {
        ArrayList<Map<String, String>> cpuinfo = new ArrayList<Map<String, String>>();
        try {
            String[] sections;
            String data = Files.readString(Path.of("/proc/cpuinfo", new String[0]), StandardCharsets.UTF_8);
            for (String section : sections = data.split("\n\n")) {
                String[] props;
                HashMap<String, String> cpuMap = new HashMap<String, String>();
                cpuinfo.add(cpuMap);
                for (String prop : props = section.split("\n")) {
                    String[] assignment = prop.split("\\s*:\\s*");
                    if (assignment.length == 2) {
                        String property = assignment[0].trim();
                        String value = assignment[1].trim();
                        cpuMap.put(property, value);
                        continue;
                    }
                    cpuMap.put(assignment[0], "");
                }
            }
        }
        catch (Exception e) {
            logger.warn("Unable to learn about CPU architecture: " + e.getMessage());
            return Optional.empty();
        }
        return Optional.of(new ProcDetails(cpuinfo));
    }

    public static class ProcDetails {
        private final List<Map<String, String>> details;

        public ProcDetails(List<Map<String, String>> details) {
            this.details = details;
        }

        public int getCoreCount() {
            return (int)this.details.stream().map(m -> (String)m.get("core id")).distinct().count();
        }

        public int getCpuCount() {
            return (int)this.details.stream().map(m -> (String)m.get("processor")).distinct().count();
        }

        public String getModelName() {
            return this.details.stream().map(m -> (String)m.get("model name")).findFirst().orElseThrow();
        }

        public String getMhz() {
            return this.details.stream().map(m -> (String)m.get("cpu MHz")).findFirst().orElseThrow();
        }

        public String getCacheInfo() {
            return this.details.stream().map(m -> (String)m.get("cache size")).findFirst().orElseThrow();
        }

        public String toString() {
            return "cores=" + this.getCoreCount() + " cpus=" + this.getCpuCount() + " mhz=" + this.getMhz() + " speedavg=" + this.getCurrentSpeed().getAverage() + " cache=" + this.getCacheInfo() + " model='" + this.getModelName() + "'";
        }

        public double getMaxFreq(int cpu) {
            return this.readFile("/sys/devices/system/cpu/cpu" + cpu + "/cpufreq/cpuinfo_max_freq", Double.NaN);
        }

        public double getCurFreq(int cpu) {
            return this.readFile("/sys/devices/system/cpu/cpu" + cpu + "/cpufreq/cpuinfo_max_freq", Double.NaN);
        }

        public double getMinFreq(int cpu) {
            return this.readFile("/sys/devices/system/cpu/cpu" + cpu + "/cpufreq/cpuinfo_min_freq", Double.NaN);
        }

        public double getCurrentSpeed(int cpu) {
            double curFreq = this.getCurFreq(cpu);
            double maxFreq = this.getMaxFreq(cpu);
            if (Double.isNaN(curFreq) || Double.isNaN(maxFreq)) {
                return Double.NaN;
            }
            return curFreq / maxFreq;
        }

        public DoubleSummaryStatistics getCurrentSpeed() {
            DoubleSummaryStatistics dss = new DoubleSummaryStatistics();
            for (int i = 0; i < this.getCpuCount(); ++i) {
                double currentSpeed = this.getCurrentSpeed(i);
                if (Double.isNaN(currentSpeed)) continue;
                dss.accept(currentSpeed);
            }
            return dss;
        }

        private double readFile(String path, double defaultValue) {
            try {
                Path readPath = Path.of(path, new String[0]);
                String content = Files.readString(readPath);
                return Double.parseDouble(content);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }
    }
}

